/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.compat.v1_8_8.bossbar;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundAddMobPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundRemoveEntitiesPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetEntityDataPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundTeleportEntityPacketAccessor;
import sba.sl.impl.nms.accessors.network.syncher.SynchedEntityDataAccessor;
import sba.sl.impl.nms.accessors.world.entity.EntityAccessor;
import sba.sl.spectator.Component;
import sba.sl.u.reflect.Reflect;

public class FakeEntityNMS<E extends Entity>
implements Listener {
    @NotNull
    protected final @NotNull List<@NotNull Player> viewers = new ArrayList<Player>();
    protected Object handler;
    private E entity;
    private boolean visible;

    protected FakeEntityNMS(@NotNull Object nmsEntity) {
        try {
            this.entity = (Entity)Reflect.fastInvoke(nmsEntity, "getBukkitEntity");
            this.handler = nmsEntity;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Object getDataWatcher() {
        return Reflect.fastInvoke(this.handler, EntityAccessor.METHOD_GET_ENTITY_DATA.get());
    }

    public void setInvisible(boolean invisible) {
        Reflect.fastInvoke(this.handler, EntityAccessor.METHOD_SET_INVISIBLE.get(), invisible);
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            if (visible) {
                this.viewers.forEach(this::onViewerAdded);
            } else {
                this.viewers.forEach(viewer -> ClassStorage.sendNMSConstructedPacket(viewer, this.createDespawnPacket()));
            }
        }
    }

    public void setHealth(double health) {
        if (this.entity instanceof Damageable) {
            Damageable entity = (Damageable)this.entity;
            entity.setHealth(health * (entity.getMaxHealth() - 0.1) + 0.1);
            Object metadataPacket = this.createMetadataPacket();
            this.viewers.forEach(viewer -> ClassStorage.sendNMSConstructedPacket(viewer, metadataPacket));
        }
    }

    public void addViewer(@NotNull Player viewer) {
        if (this.viewers.isEmpty()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)JavaPlugin.getProvidingPlugin(FakeEntityNMS.class));
        }
        if (!this.viewers.contains(viewer)) {
            this.viewers.add(viewer);
            this.onViewerAdded(viewer);
        }
    }

    public void removeViewer(@NotNull Player viewer) {
        if (this.viewers.contains(viewer)) {
            this.onViewerRemoved(viewer);
            this.viewers.remove(viewer);
        }
        if (this.viewers.isEmpty()) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    public void onViewerAdded(@NotNull Player viewer) {
        if (this.visible) {
            ClassStorage.sendNMSConstructedPacket(viewer, this.createSpawnPacket());
            this.teleport(viewer, this.createPosition(viewer));
        }
    }

    public void onViewerRemoved(@NotNull Player viewer) {
        if (this.visible) {
            ClassStorage.sendNMSConstructedPacket(viewer, this.createDespawnPacket());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player viewer = event.getPlayer();
        if (this.viewers.contains(viewer) && this.visible) {
            this.teleport(viewer, this.createPosition(viewer));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player viewer = event.getPlayer();
        if (this.viewers.contains(viewer) && this.visible) {
            this.teleport(viewer, this.createPosition(event.getTo()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player viewer = event.getPlayer();
        if (this.viewers.contains(viewer) && this.visible) {
            this.teleport(viewer, this.createPosition(viewer));
        }
    }

    @NotNull
    public Location createPosition(Player viewer) {
        return this.createPosition(viewer.getLocation());
    }

    @NotNull
    public Location createPosition(Location position) {
        Location clone = position.clone();
        clone.setPitch(clone.getPitch() - 30.0f);
        clone.setYaw(clone.getYaw());
        clone.add(clone.getDirection().multiply(40));
        return clone;
    }

    public Object createSpawnPacket() {
        if (this.entity instanceof LivingEntity) {
            return Reflect.construct(ClientboundAddMobPacketAccessor.CONSTRUCTOR_0.get(), this.handler);
        }
        return null;
    }

    public Object createDespawnPacket() {
        return Reflect.construct(ClientboundRemoveEntitiesPacketAccessor.CONSTRUCTOR_0.get(), new Object[]{new int[]{this.entity.getEntityId()}});
    }

    public Object createLocationPacket() {
        return Reflect.construct(ClientboundTeleportEntityPacketAccessor.CONSTRUCTOR_0.get(), this.handler);
    }

    public void teleport(Player viewer, Location location) {
        Reflect.fastInvoke(this.handler, EntityAccessor.METHOD_ABS_SNAP_TO.get(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
        ClassStorage.sendNMSConstructedPacket(viewer, this.createLocationPacket());
    }

    public void setCustomName(Component name) {
        Method method = EntityAccessor.METHOD_SET_CUSTOM_NAME_1.get();
        if (method != null) {
            Reflect.fastInvoke(method, ClassStorage.asMinecraftComponent(name));
        } else {
            Reflect.fastInvoke(this.handler, EntityAccessor.METHOD_SET_CUSTOM_NAME.get(), name.toLegacy());
        }
        Object metadataPacket = this.createMetadataPacket();
        this.viewers.forEach(viewer -> ClassStorage.sendNMSConstructedPacket(viewer, metadataPacket));
    }

    public void metadata(int position, Object data) {
        Object dataWatcher = this.getDataWatcher();
        if (dataWatcher != null) {
            Reflect.fastInvoke(dataWatcher, SynchedEntityDataAccessor.METHOD_WATCH.get(), position, data);
            Object metadataPacket = this.createMetadataPacket();
            this.viewers.forEach(viewer -> ClassStorage.sendNMSConstructedPacket(viewer, metadataPacket));
        }
    }

    public Object createMetadataPacket() {
        Object dataWatcher = this.getDataWatcher();
        return Reflect.construct(ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_0.get(), this.entity.getEntityId(), dataWatcher, false);
    }

    @Generated
    public Object getHandler() {
        return this.handler;
    }

    @Generated
    public E getEntity() {
        return this.entity;
    }

    @Generated
    public boolean isVisible() {
        return this.visible;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull Player> getViewers() {
        return this.viewers;
    }
}

