/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.block;

import java.util.Objects;
import lombok.Generated;
import org.bukkit.event.block.BlockReceiveGameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.ev.block.BlockReceivedGameEvent;
import sba.sl.gameevent.GameEvent;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.bukkit.gameevent.BukkitGameEvent;

public class BukkitBlockReceivedGameEvent
implements BlockReceivedGameEvent,
BukkitCancellable {
    @NotNull
    private final BlockReceiveGameEvent event;
    @Nullable
    private BlockPlacement block;
    @Nullable
    private Entity entity;
    private boolean entityConverted;
    @Nullable
    private GameEvent underlyingEvent;

    @Override
    @NotNull
    public BlockPlacement block() {
        if (this.block == null) {
            this.block = new BukkitBlockPlacement(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    @Nullable
    public Entity entity() {
        if (!this.entityConverted) {
            if (this.event.getEntity() != null) {
                this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getEntity()));
            }
            this.entityConverted = true;
        }
        return this.entity;
    }

    @Override
    @NotNull
    public GameEvent underlyingEvent() {
        if (this.underlyingEvent == null) {
            this.underlyingEvent = new BukkitGameEvent(this.event.getEvent());
        }
        return this.underlyingEvent;
    }

    @Generated
    public BukkitBlockReceivedGameEvent(@NotNull BlockReceiveGameEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitBlockReceivedGameEvent)) {
            return false;
        }
        BukkitBlockReceivedGameEvent other = (BukkitBlockReceivedGameEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockReceiveGameEvent this$event = this.event();
        BlockReceiveGameEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitBlockReceivedGameEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockReceiveGameEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitBlockReceivedGameEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public BlockReceiveGameEvent event() {
        return this.event;
    }
}

