/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import java.util.Objects;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.cn.Container;
import sba.sl.cn.ContainerFactory;
import sba.sl.ev.player.PlayerInventoryOpenEvent;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.compat.v1_20_6.InventoryViewCompat;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;

public class BukkitPlayerInventoryOpenEvent
implements PlayerInventoryOpenEvent,
BukkitCancellable {
    @NotNull
    private final InventoryOpenEvent event;
    @Nullable
    private sba.sl.pa.Player player;
    @Nullable
    private Container topInventory;
    @Nullable
    private Container bottomInventory;

    @Override
    @NotNull
    public sba.sl.pa.Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer((Player)this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @NotNull
    public Container topInventory() {
        if (this.topInventory == null) {
            this.topInventory = (Container)Objects.requireNonNull(ContainerFactory.wrapContainer(this.event.getInventory()));
        }
        return this.topInventory;
    }

    @Override
    @NotNull
    public Container bottomInventory() {
        if (this.bottomInventory == null) {
            this.bottomInventory = BukkitFeature.INVENTORY_VIEW_INTERFACE.isSupported() ? (Container)Objects.requireNonNull(ContainerFactory.wrapContainer(this.event.getView().getBottomInventory())) : (Container)Objects.requireNonNull(ContainerFactory.wrapContainer(InventoryViewCompat.getBottomInventory(this.event.getView())));
        }
        return this.bottomInventory;
    }

    @Generated
    public BukkitPlayerInventoryOpenEvent(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlayerInventoryOpenEvent)) {
            return false;
        }
        BukkitPlayerInventoryOpenEvent other = (BukkitPlayerInventoryOpenEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InventoryOpenEvent this$event = this.event();
        InventoryOpenEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlayerInventoryOpenEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InventoryOpenEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlayerInventoryOpenEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public InventoryOpenEvent event() {
        return this.event;
    }
}

