/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.ev.player.PlayerKickEvent;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.pa.Player;
import sba.sl.spectator.AudienceComponentLike;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;

public class BukkitPlayerKickEvent
implements PlayerKickEvent,
BukkitCancellable {
    @NotNull
    private final org.bukkit.event.player.PlayerKickEvent event;
    @Nullable
    private Player player;

    @Override
    @NotNull
    public Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @NotNull
    public Component leaveMessage() {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            return AdventureBackend.wrapComponent(this.event.leaveMessage());
        }
        return Component.fromLegacy(this.event.getLeaveMessage());
    }

    @Override
    public void leaveMessage(@NotNull Component leaveMessage) {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            this.event.leaveMessage(leaveMessage.as(sba.k.a.t.Component.class));
        } else {
            this.event.setLeaveMessage(leaveMessage.toLegacy());
        }
    }

    @Override
    public void leaveMessage(@NotNull ComponentLike leaveMessage) {
        if (leaveMessage instanceof AudienceComponentLike) {
            this.leaveMessage(((AudienceComponentLike)leaveMessage).asComponent(this.player()));
        } else {
            this.leaveMessage(leaveMessage.asComponent());
        }
    }

    @Override
    @NotNull
    public Component kickReason() {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            return AdventureBackend.wrapComponent(this.event.reason());
        }
        return Component.fromLegacy(this.event.getReason());
    }

    @Override
    public void kickReason(@NotNull Component kickReason) {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            this.event.reason(kickReason.as(sba.k.a.t.Component.class));
        } else {
            this.event.setReason(kickReason.toLegacy());
        }
    }

    @Override
    public void kickReason(@NotNull ComponentLike kickReason) {
        if (kickReason instanceof AudienceComponentLike) {
            this.kickReason(((AudienceComponentLike)kickReason).asComponent(this.player()));
        } else {
            this.kickReason(kickReason.asComponent());
        }
    }

    @Generated
    public BukkitPlayerKickEvent(@NotNull org.bukkit.event.player.PlayerKickEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlayerKickEvent)) {
            return false;
        }
        BukkitPlayerKickEvent other = (BukkitPlayerKickEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.player.PlayerKickEvent this$event = this.event();
        org.bukkit.event.player.PlayerKickEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlayerKickEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.player.PlayerKickEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlayerKickEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public org.bukkit.event.player.PlayerKickEvent event() {
        return this.event;
    }
}

