/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.firework;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.FireworkEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.f.FireworkEffectType;
import sba.sl.impl.bukkit.firework.BukkitFireworkEffectType;
import sba.sl.spectator.Color;
import sba.sl.u.BasicWrapper;

public class BukkitFireworkEffect
extends BasicWrapper<FireworkEffect>
implements sba.sl.f.FireworkEffect {
    public BukkitFireworkEffect(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FireworkEffect.Type type) {
        this(FireworkEffect.builder().with(type).withColor(org.bukkit.Color.WHITE).build());
    }

    public BukkitFireworkEffect(@NotNull FireworkEffect wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public String platformName() {
        return ((FireworkEffect)this.wrappedObject).getType().name();
    }

    @Override
    @NotNull
    public FireworkEffectType type() {
        return new BukkitFireworkEffectType(((FireworkEffect)this.wrappedObject).getType());
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Color> colors() {
        return ((FireworkEffect)this.wrappedObject).getColors().stream().map(color -> Color.rgb(color.getRed(), color.getGreen(), color.getBlue())).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Color> fadeColors() {
        return ((FireworkEffect)this.wrappedObject).getFadeColors().stream().map(color -> Color.rgb(color.getRed(), color.getGreen(), color.getBlue())).collect(Collectors.toList());
    }

    @Override
    public boolean flicker() {
        return ((FireworkEffect)this.wrappedObject).hasFlicker();
    }

    @Override
    public boolean trail() {
        return ((FireworkEffect)this.wrappedObject).hasTrail();
    }

    @Override
    @NotNull
    public sba.sl.f.FireworkEffect withType(@NotNull FireworkEffectType type) {
        return new BukkitFireworkEffect(FireworkEffect.builder().with(type.as(FireworkEffect.Type.class)).withColor((Iterable)((FireworkEffect)this.wrappedObject).getColors()).withFade((Iterable)((FireworkEffect)this.wrappedObject).getFadeColors()).flicker(((FireworkEffect)this.wrappedObject).hasFlicker()).trail(((FireworkEffect)this.wrappedObject).hasTrail()).build());
    }

    @Override
    @NotNull
    public sba.sl.f.FireworkEffect withColors(@NotNull @NotNull List<@NotNull Color> colors) {
        return new BukkitFireworkEffect(FireworkEffect.builder().with(((FireworkEffect)this.wrappedObject).getType()).withColor((Iterable)colors.stream().map(rgbLike -> org.bukkit.Color.fromRGB((int)rgbLike.red(), (int)rgbLike.green(), (int)rgbLike.blue())).collect(Collectors.toList())).withFade((Iterable)((FireworkEffect)this.wrappedObject).getFadeColors()).flicker(((FireworkEffect)this.wrappedObject).hasFlicker()).trail(((FireworkEffect)this.wrappedObject).hasTrail()).build());
    }

    @Override
    @NotNull
    public sba.sl.f.FireworkEffect withFadeColors(@NotNull @NotNull List<@NotNull Color> fadeColors) {
        return new BukkitFireworkEffect(FireworkEffect.builder().with(((FireworkEffect)this.wrappedObject).getType()).withColor((Iterable)((FireworkEffect)this.wrappedObject).getColors()).withFade((Iterable)fadeColors.stream().map(rgbLike -> org.bukkit.Color.fromRGB((int)rgbLike.red(), (int)rgbLike.green(), (int)rgbLike.blue())).collect(Collectors.toList())).flicker(((FireworkEffect)this.wrappedObject).hasFlicker()).trail(((FireworkEffect)this.wrappedObject).hasTrail()).build());
    }

    @Override
    @NotNull
    public sba.sl.f.FireworkEffect withFlicker(boolean flicker) {
        return new BukkitFireworkEffect(FireworkEffect.builder().with(((FireworkEffect)this.wrappedObject).getType()).withColor((Iterable)((FireworkEffect)this.wrappedObject).getColors()).withFade((Iterable)((FireworkEffect)this.wrappedObject).getFadeColors()).flicker(flicker).trail(((FireworkEffect)this.wrappedObject).hasTrail()).build());
    }

    @Override
    @NotNull
    public sba.sl.f.FireworkEffect withTrail(boolean trail) {
        return new BukkitFireworkEffect(FireworkEffect.builder().with(((FireworkEffect)this.wrappedObject).getType()).withColor((Iterable)((FireworkEffect)this.wrappedObject).getColors()).withFade((Iterable)((FireworkEffect)this.wrappedObject).getFadeColors()).flicker(((FireworkEffect)this.wrappedObject).hasFlicker()).trail(trail).build());
    }

    @Override
    public boolean is(@Nullable Object object) {
        if (object instanceof FireworkEffect.Type) {
            return ((FireworkEffect)this.wrappedObject).getType() == object;
        }
        if (object instanceof FireworkEffect || object instanceof sba.sl.f.FireworkEffect) {
            return this.equals(object);
        }
        return this.equals(sba.sl.f.FireworkEffect.ofNullable(object));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type == FireworkEffect.Type.class) {
            return (T)((FireworkEffect)this.wrappedObject).getType();
        }
        return super.as(type);
    }
}

