/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item;

import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.Block;
import sba.sl.i.ItemType;
import sba.sl.impl.bukkit.block.BukkitBlock1_13;
import sba.sl.impl.bukkit.item.BukkitItemTypeRegistry1_13;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BukkitItemType1_13
extends BasicWrapper<Material>
implements ItemType {
    public BukkitItemType1_13(@NotNull Material wrappedObject) {
        super(wrappedObject);
        if (!wrappedObject.isItem()) {
            throw new UnsupportedOperationException("BukkitItemTypeHolder can wrap only item types!!!");
        }
    }

    @Override
    @NotNull
    public String platformName() {
        return ((Material)this.wrappedObject).name();
    }

    @Override
    public int maxStackSize() {
        return ((Material)this.wrappedObject).getMaxStackSize();
    }

    @Override
    @Nullable
    public Block block() {
        if (!((Material)this.wrappedObject).isBlock()) {
            return null;
        }
        return new BukkitBlock1_13((Material)this.wrappedObject);
    }

    @Override
    public boolean hasTag(@NotNull Object tag) {
        ResourceLocation key = tag instanceof ResourceLocation ? (ResourceLocation)tag : ResourceLocation.of(tag.toString());
        Tag bukkitTag = Bukkit.getTag((String)"items", (NamespacedKey)new NamespacedKey(key.namespace(), key.path()), Material.class);
        if (bukkitTag != null) {
            return bukkitTag.isTagged((Keyed)((Material)this.wrappedObject));
        }
        if (!"minecraft".equals(key.namespace())) {
            return false;
        }
        String value = key.path();
        return BukkitItemTypeRegistry1_13.hasTagInBackPorts((Material)this.wrappedObject, value);
    }

    @Override
    public boolean is(@Nullable Object object) {
        String str;
        if (object instanceof Material || object instanceof ItemType) {
            return this.equals(object);
        }
        if (object instanceof String && (str = (String)object).startsWith("#")) {
            return this.hasTag(str.substring(1));
        }
        return this.equals(ItemType.ofNullable(object));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type == ItemStack.class) {
            return (T)new ItemStack((Material)this.wrappedObject);
        }
        return super.as(type);
    }

    @Override
    @NotNull
    public ResourceLocation location() {
        NamespacedKey key = ((Material)this.wrappedObject).getKey();
        return ResourceLocation.of(key.getNamespace(), key.getKey());
    }
}

