/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.Potion;
import sba.sl.impl.bukkit.item.meta.BukkitPotion1_8;
import sba.sl.impl.item.meta.PotionRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitPotionRegistry1_8
extends PotionRegistry {
    public BukkitPotionRegistry1_8() {
        this.specialType(PotionType.class, BukkitPotion1_8::new);
        this.specialType(org.bukkit.potion.Potion.class, BukkitPotion1_8::new);
    }

    @Override
    @Nullable
    protected Potion resolveMappingPlatform(@NotNull ResourceLocation location) {
        block24: {
            if (!"minecraft".equals(location.namespace())) {
                return null;
            }
            try {
                String path = location.path().toUpperCase(Locale.ROOT);
                int variant = 0;
                if (path.startsWith("LONG_")) {
                    path = path.substring(5);
                    variant = 1;
                } else if (path.startsWith("STRONG_")) {
                    path = path.substring(7);
                    variant = 2;
                }
                switch (path) {
                    case "LEAPING": {
                        path = "JUMP";
                        break;
                    }
                    case "SWIFTNESS": {
                        path = "SPEED";
                        break;
                    }
                    case "HEALING": {
                        path = "INSTANT_HEAL";
                        break;
                    }
                    case "HARMING": {
                        path = "INSTANT_DAMAGE";
                        break;
                    }
                    case "REGENERATION": {
                        path = "REGEN";
                    }
                }
                PotionType type = PotionType.valueOf((String)path);
                if (variant == 1) {
                    if (type != PotionType.WATER && type != PotionType.INSTANT_DAMAGE && type != PotionType.INSTANT_HEAL) {
                        return new BukkitPotion1_8(new org.bukkit.potion.Potion(type, 1, false, true));
                    }
                    break block24;
                }
                if (variant == 2) {
                    if (type.getMaxLevel() >= 2) {
                        return new BukkitPotion1_8(new org.bukkit.potion.Potion(type, 2, false, false));
                    }
                    break block24;
                }
                return new BukkitPotion1_8(type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull Potion> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<org.bukkit.potion.Potion, Potion>(() -> Arrays.stream(PotionType.values()).flatMap(potion -> {
            ArrayList<org.bukkit.potion.Potion> results = new ArrayList<org.bukkit.potion.Potion>();
            results.add(new org.bukkit.potion.Potion(potion));
            if (potion != PotionType.WATER && potion != PotionType.INSTANT_DAMAGE && potion != PotionType.INSTANT_HEAL) {
                results.add(new org.bukkit.potion.Potion(potion, 1, false, true));
            }
            if (potion.getMaxLevel() >= 2) {
                results.add(new org.bukkit.potion.Potion(potion, 2, false, false));
            }
            return results.stream();
        }), BukkitPotion1_8::new, BukkitPotion1_8::constructKey, (potion, literal) -> BukkitPotion1_8.constructKey(potion).path().contains((CharSequence)literal), (potion, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

