/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.Potion;
import sba.sl.impl.bukkit.item.meta.BukkitPotion1_9;
import sba.sl.impl.item.meta.PotionRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitPotionRegistry1_9
extends PotionRegistry {
    public BukkitPotionRegistry1_9() {
        this.specialType(PotionType.class, BukkitPotion1_9::new);
        this.specialType(PotionData.class, BukkitPotion1_9::new);
    }

    @Override
    @Nullable
    protected Potion resolveMappingPlatform(@NotNull ResourceLocation location) {
        block26: {
            if (!"minecraft".equals(location.namespace())) {
                return null;
            }
            try {
                String path = location.path().toUpperCase(Locale.ROOT);
                int variant = 0;
                if (path.startsWith("LONG_")) {
                    path = path.substring(5);
                    variant = 1;
                } else if (path.startsWith("STRONG_")) {
                    path = path.substring(7);
                    variant = 2;
                }
                switch (path) {
                    case "EMPTY": {
                        path = "UNCRAFTABLE";
                        break;
                    }
                    case "LEAPING": {
                        path = "JUMP";
                        break;
                    }
                    case "SWIFTNESS": {
                        path = "SPEED";
                        break;
                    }
                    case "HEALING": {
                        path = "INSTANT_HEAL";
                        break;
                    }
                    case "HARMING": {
                        path = "INSTANT_DAMAGE";
                        break;
                    }
                    case "REGENERATION": {
                        path = "REGEN";
                    }
                }
                PotionType type = PotionType.valueOf((String)path);
                if (variant == 1) {
                    if (type.isExtendable()) {
                        return new BukkitPotion1_9(new PotionData(type, true, false));
                    }
                    break block26;
                }
                if (variant == 2) {
                    if (type.isUpgradeable()) {
                        return new BukkitPotion1_9(new PotionData(type, false, true));
                    }
                    break block26;
                }
                return new BukkitPotion1_9(type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull Potion> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<PotionData, Potion>(() -> Arrays.stream(PotionType.values()).flatMap(potion -> {
            ArrayList<PotionData> results = new ArrayList<PotionData>();
            results.add(new PotionData(potion));
            if (potion.isExtendable()) {
                results.add(new PotionData(potion, true, false));
            }
            if (potion.isUpgradeable()) {
                results.add(new PotionData(potion, false, true));
            }
            return results.stream();
        }), BukkitPotion1_9::new, BukkitPotion1_9::constructKey, (potion, literal) -> BukkitPotion1_9.constructKey(potion).path().contains((CharSequence)literal), (potion, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

