/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.particle;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.particle.BukkitParticleType1_8;
import sba.sl.impl.particle.ParticleTypeRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.pa.ParticleType;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitParticleTypeRegistry1_8
extends ParticleTypeRegistry {
    @NotNull
    public static final @NotNull Map<@NotNull String, Integer> PARTICLE_NAME_TO_ORDINAL = Map.ofEntries(Map.entry("poof", 0), Map.entry("explosion", 1), Map.entry("explosion_emitter", 2), Map.entry("firework", 3), Map.entry("bubble", 4), Map.entry("splash", 5), Map.entry("fishing", 6), Map.entry("underwater", 7), Map.entry("suspended_depth", 8), Map.entry("crit", 9), Map.entry("enchanted_hit", 10), Map.entry("smoke", 11), Map.entry("large_smoke", 12), Map.entry("effect", 13), Map.entry("instant_effect", 14), Map.entry("entity_effect", 15), Map.entry("ambient_entity_effect", 16), Map.entry("witch", 17), Map.entry("dripping_water", 18), Map.entry("dripping_lava", 19), Map.entry("angry_villager", 20), Map.entry("happy_villager", 21), Map.entry("mycelium", 22), Map.entry("note", 23), Map.entry("portal", 24), Map.entry("enchant", 25), Map.entry("flame", 26), Map.entry("lava", 27), Map.entry("footstep", 28), Map.entry("cloud", 29), Map.entry("dust", 30), Map.entry("item_snowball", 31), Map.entry("snow_shovel", 32), Map.entry("item_slime", 33), Map.entry("heart", 34), Map.entry("block_marker", 35), Map.entry("item", 36), Map.entry("block", 37), Map.entry("block_dust", 38), Map.entry("rain", 39), Map.entry("take", 40), Map.entry("elder_guardian", 41));
    @NotNull
    public static final @NotNull Map<@NotNull Integer, String> ORDINAL_TO_PARTICLE_NAME = PARTICLE_NAME_TO_ORDINAL.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getValue, Map.Entry::getKey));

    @Override
    @Nullable
    protected ParticleType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        Integer id = PARTICLE_NAME_TO_ORDINAL.get(location.path());
        if (id != null) {
            return new BukkitParticleType1_8(id);
        }
        return null;
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull ParticleType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<Map.Entry, ParticleType>(() -> PARTICLE_NAME_TO_ORDINAL.entrySet().stream(), entry -> new BukkitParticleType1_8((Integer)entry.getValue()), entry -> ResourceLocation.of((String)entry.getKey()), (entry, literal) -> ((String)entry.getKey()).contains((CharSequence)literal), (entry, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

