/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.spectator;

import java.util.Locale;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.spectator.BukkitBook;
import sba.sl.impl.bukkit.spectator.SpigotBackendAdventureExtension;
import sba.sl.impl.bukkit.spectator.audience.adapter.BukkitAdapter;
import sba.sl.impl.bukkit.spectator.audience.adapter.BukkitConsoleAdapter;
import sba.sl.impl.bukkit.spectator.audience.adapter.BukkitPlayerAdapter;
import sba.sl.impl.bukkit.spectator.bossbar.BukkitBossBar1_8;
import sba.sl.impl.bukkit.spectator.bossbar.BukkitBossBar1_9;
import sba.sl.impl.bukkit.spectator.sound.BukkitDummySoundSource;
import sba.sl.impl.bukkit.spectator.sound.BukkitSoundSource;
import sba.sl.impl.bukkit.spectator.sound.BukkitSoundStart;
import sba.sl.impl.bukkit.spectator.sound.BukkitSoundStop;
import sba.sl.impl.bukkit.spectator.title.BukkitTitle;
import sba.sl.impl.bungee.spectator.AbstractBungeeBackend;
import sba.sl.impl.spectator.SpectatorBackend;
import sba.sl.nbt.SNBTSerializer;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.spectator.ShadowColor;
import sba.sl.spectator.audience.ConsoleAudience;
import sba.sl.spectator.audience.PlayerAudience;
import sba.sl.spectator.audience.adapter.Adapter;
import sba.sl.spectator.sound.SoundSource;

public class SpigotBackend
extends AbstractBungeeBackend {
    private SpectatorBackend adventureBackend;

    public SpigotBackend() {
        if (BukkitFeature.NBT_LONG_ARRAYS.isSupported()) {
            snbtSerializer = SNBTSerializer.builder().shouldSaveLongArraysDirectly(true).build();
        }
        if (BukkitFeature.ADVENTURE.isSupported()) {
            this.adventureBackend = SpigotBackendAdventureExtension.initAdventureBackend(snbtSerializer);
        }
    }

    public boolean hasAdventure() {
        return this.adventureBackend != null;
    }

    @Override
    public  @NotNull BossBar.Builder bossBar() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.bossBar();
        }
        if (BukkitFeature.MODERN_BOSSBARS.isSupported()) {
            return new BukkitBossBar1_9.BukkitBossBarBuilder();
        }
        return new BukkitBossBar1_8.BukkitBossBarBuilder();
    }

    @Override
    public  @NotNull SoundStart.Builder soundStart() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.soundStart();
        }
        return new BukkitSoundStart.BukkitSoundStartBuilder();
    }

    @Override
    public  @NotNull SoundStop.Builder soundStop() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.soundStop();
        }
        return new BukkitSoundStop.BukkitSoundStartBuilder();
    }

    @Override
    @NotNull
    public SoundSource soundSource(@NotNull String source) {
        if (this.adventureBackend != null) {
            return this.adventureBackend.soundSource(source);
        }
        if (!BukkitFeature.SOUND_CATEGORY.isSupported()) {
            return new BukkitDummySoundSource();
        }
        try {
            return new BukkitSoundSource(SoundCategory.valueOf((String)source.toUpperCase(Locale.ROOT)));
        }
        catch (Throwable t) {
            return new BukkitSoundSource(SoundCategory.MASTER);
        }
    }

    @Override
    @Nullable
    public Component fromPlatform(@NotNull Object platformObject) {
        if (this.adventureBackend != null) {
            try {
                return this.adventureBackend.fromPlatform(platformObject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return super.fromPlatform(platformObject);
    }

    @Override
    public  @NotNull Title.Builder title() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.title();
        }
        return new BukkitTitle.BukkitTitleBuilder();
    }

    @Override
    public  @NotNull Book.Builder book() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.book();
        }
        return new BukkitBook.BukkitBookBuilder();
    }

    @Override
    @NotNull
    public Component empty() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.empty();
        }
        return super.empty();
    }

    @Override
    @NotNull
    public Component newLine() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.newLine();
        }
        return super.newLine();
    }

    @Override
    @NotNull
    public Component space() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.space();
        }
        return super.space();
    }

    @Override
    public  @NotNull BlockNBTComponent.Builder blockNBT() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.blockNBT();
        }
        return super.blockNBT();
    }

    @Override
    public  @NotNull EntityNBTComponent.Builder entityNBT() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.entityNBT();
        }
        return super.entityNBT();
    }

    @Override
    public  @NotNull KeybindComponent.Builder keybind() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.keybind();
        }
        return super.keybind();
    }

    @Override
    public  @NotNull ScoreComponent.Builder score() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.score();
        }
        return super.score();
    }

    @Override
    public  @NotNull SelectorComponent.Builder selector() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.selector();
        }
        return super.selector();
    }

    @Override
    public  @NotNull StorageNBTComponent.Builder storageNBT() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.storageNBT();
        }
        return super.storageNBT();
    }

    @Override
    public  @NotNull TextComponent.Builder text() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.text();
        }
        return super.text();
    }

    @Override
    public  @NotNull TranslatableComponent.Builder translatable() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.translatable();
        }
        return super.translatable();
    }

    @Override
    @NotNull
    public Color rgb(int red, int green, int blue) {
        if (this.adventureBackend != null) {
            return this.adventureBackend.rgb(red, green, blue);
        }
        return super.rgb(red, green, blue);
    }

    @Override
    @Nullable
    public Color named(@NotNull String name) {
        if (this.adventureBackend != null) {
            return this.adventureBackend.named(name);
        }
        return super.named(name);
    }

    @Override
    @NotNull
    public Color hexOrName(@NotNull String hex) {
        if (this.adventureBackend != null) {
            return this.adventureBackend.hexOrName(hex);
        }
        return super.hexOrName(hex);
    }

    @Override
    @NotNull
    public Color nearestNamedTo(@Nullable Color color) {
        if (this.adventureBackend != null) {
            return this.adventureBackend.nearestNamedTo(color);
        }
        return super.nearestNamedTo(color);
    }

    @Override
    public  @NotNull ClickEvent.Builder clickEvent() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.clickEvent();
        }
        return super.clickEvent();
    }

    @Override
    public  @NotNull HoverEvent.Builder hoverEvent() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.hoverEvent();
        }
        return super.hoverEvent();
    }

    @Override
    public  @NotNull EntityContent.Builder entityContent() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.entityContent();
        }
        return super.entityContent();
    }

    @Override
    public  @NotNull ItemContent.Builder itemContent() {
        if (this.adventureBackend != null) {
            return this.adventureBackend.itemContent();
        }
        return super.itemContent();
    }

    @Override
    @NotNull
    public Component fromLegacy(@NotNull String legacy) {
        if (this.adventureBackend != null) {
            return this.adventureBackend.fromLegacy(legacy);
        }
        return super.fromLegacy(legacy);
    }

    @Override
    @NotNull
    public Component fromLegacy(@NotNull String legacy, char colorChar) {
        if (this.adventureBackend != null) {
            return this.adventureBackend.fromLegacy(legacy, colorChar);
        }
        return super.fromLegacy(legacy, colorChar);
    }

    @Override
    @NotNull
    public Component fromJson(@NotNull String json) {
        if (this.adventureBackend != null) {
            return this.adventureBackend.fromJson(json);
        }
        return super.fromJson(json);
    }

    @Override
    @NotNull
    public ShadowColor shadowHex(@NotNull String hex) {
        if (this.adventureBackend != null) {
            return this.adventureBackend.shadowHex(hex);
        }
        return super.shadowHex(hex);
    }

    @Override
    @NotNull
    public ShadowColor shadowArgb(int alpha, int red, int green, int blue) {
        if (this.adventureBackend != null) {
            return this.adventureBackend.shadowArgb(alpha, red, green, blue);
        }
        return super.shadowArgb(alpha, red, green, blue);
    }

    @NotNull
    public <A extends Adapter> A adapter(@NotNull sba.sl.s.CommandSender wrapper, @NotNull CommandSender sender) {
        if (this.adventureBackend != null) {
            return SpigotBackendAdventureExtension.adapter(wrapper, sender);
        }
        if (sender instanceof Player && wrapper instanceof PlayerAudience) {
            return (A)new BukkitPlayerAdapter((PlayerAudience)((Object)wrapper), (Player)sender);
        }
        if (sender instanceof ConsoleCommandSender && wrapper instanceof ConsoleAudience) {
            return (A)new BukkitConsoleAdapter((ConsoleAudience)((Object)wrapper), (ConsoleCommandSender)sender);
        }
        return (A)new BukkitAdapter(wrapper, sender);
    }
}

