/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.tasker;

import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;
import sba.sl.impl.bukkit.tasker.task.BukkitTask;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.t.ThreadProperty;
import sba.sl.t.task.Task;
import sba.sl.t.task.TaskBase;
import sba.sl.u.annotations.Service;

@Service
public class BukkitTasker
extends Tasker {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final BukkitScheduler scheduler;

    public BukkitTasker(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.scheduler = plugin.getServer().getScheduler();
    }

    @Override
    @NotNull
    protected Task run0(@NotNull ThreadProperty property, @NotNull Runnable runnable) {
        if (this.isAsync(property)) {
            return new BukkitTask(this.scheduler.runTaskAsynchronously(this.plugin, runnable));
        }
        return new BukkitTask(this.scheduler.runTask(this.plugin, runnable));
    }

    @Override
    @NotNull
    protected Task runDelayed0(@NotNull ThreadProperty property, @NotNull Runnable runnable, long delay, @NotNull TaskerTime delayUnit) {
        if (this.isAsync(property)) {
            return new BukkitTask(this.scheduler.runTaskLaterAsynchronously(this.plugin, runnable, delayUnit.getBukkitTime(delay)));
        }
        return new BukkitTask(this.scheduler.runTaskLater(this.plugin, runnable, delayUnit.getBukkitTime(delay)));
    }

    @Override
    @NotNull
    protected Task runRepeatedly0(@NotNull ThreadProperty property, @NotNull Runnable runnable, long period, @NotNull TaskerTime periodUnit) {
        return this.runDelayedAndRepeatedly0(property, runnable, 0L, TaskerTime.TICKS, period, periodUnit);
    }

    @Override
    @NotNull
    protected Task runRepeatedly0(@NotNull ThreadProperty property, @NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, long period, @NotNull TaskerTime periodUnit) {
        return this.runDelayedAndRepeatedly0(property, selfCancellable, 0L, TaskerTime.TICKS, period, periodUnit);
    }

    @Override
    @NotNull
    protected Task runDelayedAndRepeatedly0(@NotNull ThreadProperty property, @NotNull Runnable runnable, long delay, @NotNull TaskerTime delayUnit, long period, @NotNull TaskerTime periodUnit) {
        if (this.isAsync(property)) {
            return new BukkitTask(this.scheduler.runTaskTimerAsynchronously(this.plugin, runnable, delayUnit.getBukkitTime(delay), periodUnit.getBukkitTime(period)));
        }
        return new BukkitTask(this.scheduler.runTaskTimer(this.plugin, runnable, delayUnit.getBukkitTime(delay), periodUnit.getBukkitTime(period)));
    }

    @Override
    @NotNull
    protected Task runDelayedAndRepeatedly0(@NotNull ThreadProperty property, final @NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, long delay, @NotNull TaskerTime delayUnit, long period, @NotNull TaskerTime periodUnit) {
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                selfCancellable.accept(() -> (this).cancel());
            }
        };
        if (this.isAsync(property)) {
            return new BukkitTask(runnable.runTaskTimerAsynchronously(this.plugin, delayUnit.getBukkitTime(delay), periodUnit.getBukkitTime(period)));
        }
        return new BukkitTask(runnable.runTaskTimer(this.plugin, delayUnit.getBukkitTime(delay), periodUnit.getBukkitTime(period)));
    }

    private boolean isAsync(@NotNull ThreadProperty property) {
        return property == DefaultThreads.ASYNC_THREAD;
    }
}

