/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.world;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.GameRule;
import org.bukkit.Particle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.particle.BukkitParticleConverter;
import sba.sl.impl.bukkit.particle.BukkitParticleConverter1_8;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.server.VVV.EnumParticleAccessor;
import sba.sl.impl.nms.accessors.server.level.ServerLevelAccessor;
import sba.sl.impl.world.chunk.Chunks;
import sba.sl.spectator.audience.PlayerAudience;
import sba.sl.u.BasicWrapper;
import sba.sl.u.reflect.Reflect;
import sba.sl.w.Location;
import sba.sl.w.World;
import sba.sl.w.chunk.Chunk;
import sba.sl.w.difficulty.DifficultyType;
import sba.sl.w.dimension.DimensionType;
import sba.sl.w.gamerule.GameRuleType;

public class BukkitWorld
extends BasicWrapper<org.bukkit.World>
implements World {
    public BukkitWorld(@NotNull org.bukkit.World wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return ((org.bukkit.World)this.wrappedObject).getUID();
    }

    @Override
    @NotNull
    public String getName() {
        return ((org.bukkit.World)this.wrappedObject).getName();
    }

    @Override
    public int getMinY() {
        if (BukkitFeature.WORLD_MIN_HEIGHT.isSupported()) {
            return ((org.bukkit.World)this.wrappedObject).getMinHeight();
        }
        return 0;
    }

    @Override
    public int getMaxY() {
        return ((org.bukkit.World)this.wrappedObject).getMaxHeight();
    }

    @Override
    @NotNull
    public DifficultyType getDifficulty() {
        return DifficultyType.of(((org.bukkit.World)this.wrappedObject).getDifficulty());
    }

    @Override
    @NotNull
    public DimensionType getDimension() {
        return DimensionType.of(((org.bukkit.World)this.wrappedObject).getEnvironment());
    }

    @Override
    @Nullable
    public Chunk getChunkAt(int x, int z) {
        return Chunks.wrapChunk(((org.bukkit.World)this.wrappedObject).getChunkAt(x, z));
    }

    @Override
    @Nullable
    public Chunk getChunkAt(@NotNull Location location) {
        return Chunks.wrapChunk(((org.bukkit.World)this.wrappedObject).getChunkAt(location.as(org.bukkit.Location.class)));
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Entity> getEntities() {
        return ((org.bukkit.World)this.wrappedObject).getEntities().stream().map(Entities::wrapEntity).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public <T> T getGameRuleValue(@NotNull GameRuleType holder) {
        if (BukkitFeature.GAME_RULE_API.isSupported()) {
            return (T)((org.bukkit.World)this.wrappedObject).getGameRuleValue(holder.as(GameRule.class));
        }
        String val = ((org.bukkit.World)this.wrappedObject).getGameRuleValue(holder.platformName());
        if (val == null) {
            return null;
        }
        try {
            return (T)Integer.valueOf(val);
        }
        catch (Throwable ignored) {
            if ("true".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val)) {
                return (T)Boolean.valueOf(val);
            }
            return (T)val;
        }
    }

    @Override
    public <T> void setGameRuleValue(@NotNull GameRuleType holder, @NotNull T value) {
        if (BukkitFeature.GAME_RULE_API.isSupported()) {
            ((org.bukkit.World)this.wrappedObject).setGameRule(holder.as(GameRule.class), value);
        } else {
            ((org.bukkit.World)this.wrappedObject).setGameRuleValue(holder.platformName(), value.toString());
        }
    }

    @Override
    public long getTime() {
        return ((org.bukkit.World)this.wrappedObject).getTime();
    }

    @Override
    public void setTime(long time) {
        ((org.bukkit.World)this.wrappedObject).setTime(time);
    }

    @Override
    public void sendParticle(@NotNull sba.sl.pa.Particle particle, @NotNull Location location) {
        if (!this.equals(location.getWorld())) {
            throw new IllegalArgumentException("The location of the sent particle is not in the correct world!");
        }
        if (BukkitFeature.EXTENDED_PARTICLE_METHOD.isSupported()) {
            ((org.bukkit.World)this.wrappedObject).spawnParticle(particle.particleType().as(Particle.class), location.as(org.bukkit.Location.class), particle.count(), particle.offset().getX(), particle.offset().getY(), particle.offset().getZ(), particle.particleData(), particle.specialData() != null ? BukkitParticleConverter.convertParticleData(particle.specialData()) : null, particle.longDistance());
        } else if (BukkitFeature.PARTICLES_API.isSupported()) {
            ((org.bukkit.World)this.wrappedObject).spawnParticle(particle.particleType().as(Particle.class), location.as(org.bukkit.Location.class), particle.count(), particle.offset().getX(), particle.offset().getY(), particle.offset().getZ(), particle.particleData(), particle.specialData() != null ? BukkitParticleConverter.convertParticleData(particle.specialData()) : null);
        } else {
            Object enumParticle = particle.particleType().as(EnumParticleAccessor.TYPE.get());
            Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), ServerLevelAccessor.METHOD_FUNC_180505_A.get(), enumParticle, particle.longDistance(), Float.valueOf((float)location.getX()), Float.valueOf((float)location.getY()), Float.valueOf((float)location.getZ()), particle.count(), Float.valueOf((float)particle.offset().getX()), Float.valueOf((float)particle.offset().getY()), Float.valueOf((float)particle.offset().getZ()), Float.valueOf((float)particle.particleData()), particle.specialData() != null ? BukkitParticleConverter1_8.convertParticleData(particle.specialData()) : new int[]{});
        }
    }

    @Override
    public boolean isSpawningOfAnimalsAllowed() {
        return ((org.bukkit.World)this.wrappedObject).getAllowAnimals();
    }

    @Override
    public boolean isSpawningOfMonstersAllowed() {
        return ((org.bukkit.World)this.wrappedObject).getAllowMonsters();
    }

    @Override
    @NotNull
    public BlockPlacement getHighestBlockAt(int x, int z) {
        return new BukkitBlockPlacement(((org.bukkit.World)this.wrappedObject).getHighestBlockAt(x, z));
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return ((org.bukkit.World)this.wrappedObject).getHighestBlockYAt(x, z);
    }

    @Override
    @NotNull
    public @NotNull Iterable<? extends @NotNull PlayerAudience> audiences() {
        return Server.getConnectedPlayersFromWorld(this);
    }
}

