/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.world.chunk;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.world.BukkitWorld;
import sba.sl.u.BasicWrapper;
import sba.sl.w.World;
import sba.sl.w.chunk.Chunk;

public class BukkitChunk
extends BasicWrapper<org.bukkit.Chunk>
implements Chunk {
    public BukkitChunk(@NotNull org.bukkit.Chunk wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public int getX() {
        return ((org.bukkit.Chunk)this.wrappedObject).getX();
    }

    @Override
    public int getZ() {
        return ((org.bukkit.Chunk)this.wrappedObject).getZ();
    }

    @Override
    @NotNull
    public World getWorld() {
        return new BukkitWorld(((org.bukkit.Chunk)this.wrappedObject).getWorld());
    }

    @Override
    @NotNull
    public BlockPlacement getBlock(@Range(from=0L, to=15L) int x, int y, @Range(from=0L, to=15L) int z) {
        return new BukkitBlockPlacement(((org.bukkit.Chunk)this.wrappedObject).getBlock(x, y, z));
    }

    @Override
    @NotNull
    public @NotNull Entity @NotNull [] getEntities() {
        return (Entity[])Arrays.stream(((org.bukkit.Chunk)this.wrappedObject).getEntities()).map(Entities::wrapEntity).filter(Objects::nonNull).toArray(Entity[]::new);
    }

    @Override
    public boolean isLoaded() {
        return ((org.bukkit.Chunk)this.wrappedObject).isLoaded();
    }

    @Override
    public boolean load() {
        return ((org.bukkit.Chunk)this.wrappedObject).load();
    }

    @Override
    public boolean load(boolean generate) {
        return ((org.bukkit.Chunk)this.wrappedObject).load(generate);
    }

    @Override
    public boolean unload() {
        return ((org.bukkit.Chunk)this.wrappedObject).unload();
    }

    @Override
    public boolean unload(boolean save) {
        return ((org.bukkit.Chunk)this.wrappedObject).unload(save);
    }

    @Override
    public boolean addPluginChunkTicket() {
        if (BukkitFeature.CHUNK_TICKET_API.isSupported()) {
            return ((org.bukkit.Chunk)this.wrappedObject).addPluginChunkTicket(BukkitCore.getPlugin());
        }
        return false;
    }

    @Override
    public boolean removePluginChunkTicket() {
        if (BukkitFeature.CHUNK_TICKET_API.isSupported()) {
            return ((org.bukkit.Chunk)this.wrappedObject).removePluginChunkTicket(BukkitCore.getPlugin());
        }
        return false;
    }

    @Override
    public boolean hasPluginChunkTicket() {
        if (BukkitFeature.CHUNK_TICKET_API.isSupported()) {
            return ((org.bukkit.Chunk)this.wrappedObject).getPluginChunkTickets().contains(BukkitCore.getPlugin());
        }
        return false;
    }
}

