/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bungee.spectator.event;

import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.jetbrains.annotations.NotNull;
import sba.sl.impl.bungee.spectator.AbstractBungeeBackend;
import sba.sl.impl.bungee.spectator.BungeeChatFeature;
import sba.sl.impl.bungee.spectator.compat.HoverEventCompat;
import sba.sl.impl.bungee.spectator.event.hover.BungeeEntityContent;
import sba.sl.impl.bungee.spectator.event.hover.BungeeItemContent;
import sba.sl.impl.bungee.spectator.event.hover.BungeeLegacyEntityContent;
import sba.sl.impl.bungee.spectator.event.hover.BungeeLegacyItemContent;
import sba.sl.spectator.Component;
import sba.sl.spectator.event.HoverEvent;
import sba.sl.u.BasicWrapper;
import sba.sl.u.Preconditions;

public class BungeeHoverEvent
extends BasicWrapper<HoverEvent>
implements sba.sl.spectator.event.HoverEvent {
    public BungeeHoverEvent(@NotNull HoverEvent wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public HoverEvent.Action action() {
        try {
            return HoverEvent.Action.valueOf(((HoverEvent)this.wrappedObject).getAction().name());
        }
        catch (Throwable ignored) {
            return HoverEvent.Action.SHOW_TEXT;
        }
    }

    @Override
    @NotNull
    public sba.sl.spectator.event.hover.Content content() {
        if (BungeeChatFeature.MODERN_HOVER_CONTENTS.isSupported()) {
            List content = ((HoverEvent)this.wrappedObject).getContents();
            switch (((HoverEvent)this.wrappedObject).getAction()) {
                case SHOW_ENTITY: {
                    if (content.isEmpty()) {
                        return null;
                    }
                    return new BungeeEntityContent((Entity)content.get(0));
                }
                case SHOW_ITEM: {
                    if (content.isEmpty()) {
                        return null;
                    }
                    return new BungeeItemContent((Item)content.get(0));
                }
            }
            if (content.isEmpty()) {
                return Component.empty();
            }
            if (content.size() == 1) {
                Text text = (Text)content.get(0);
                if (text.getValue() instanceof BaseComponent[]) {
                    return AbstractBungeeBackend.wrapComponent((BaseComponent)new TextComponent((BaseComponent[])text.getValue()));
                }
                if (text.getValue() instanceof BaseComponent) {
                    return AbstractBungeeBackend.wrapComponent((BaseComponent)text.getValue());
                }
                return AbstractBungeeBackend.wrapComponent((BaseComponent)new TextComponent(text.getValue().toString()));
            }
            ArrayList<Object> components = new ArrayList<Object>();
            for (Content textC : content) {
                Text text = (Text)textC;
                if (text.getValue() instanceof BaseComponent[]) {
                    components.add(new TextComponent((BaseComponent[])text.getValue()));
                    continue;
                }
                if (text.getValue() instanceof BaseComponent) {
                    components.add((BaseComponent)text.getValue());
                    continue;
                }
                components.add(new TextComponent(text.getValue().toString()));
            }
            return AbstractBungeeBackend.wrapComponent((BaseComponent)new TextComponent((BaseComponent[])components.toArray(BaseComponent[]::new)));
        }
        BaseComponent[] values = HoverEventCompat.getValue((HoverEvent)this.wrappedObject);
        switch (((HoverEvent)this.wrappedObject).getAction()) {
            case SHOW_ENTITY: {
                if (values.length == 1 && values[0] instanceof TextComponent) {
                    return new BungeeLegacyItemContent(((TextComponent)values[0]).getText());
                }
                return null;
            }
            case SHOW_ITEM: {
                if (values.length == 1 && values[0] instanceof TextComponent) {
                    return new BungeeLegacyEntityContent(((TextComponent)values[0]).getText());
                }
                return null;
            }
        }
        if (values.length == 0) {
            return Component.empty();
        }
        if (values.length == 1) {
            return AbstractBungeeBackend.wrapComponent(values[0]);
        }
        return AbstractBungeeBackend.wrapComponent((BaseComponent)new TextComponent(new BaseComponent[]{values[0]}));
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        try {
            return super.as(type);
        }
        catch (Throwable ignored) {
            return AbstractBungeeBackend.getAdditionalHoverEventConverter().convert(this, type);
        }
    }

    public static class BungeeHoverEventBuilder
    implements HoverEvent.Builder {
        private HoverEvent.Action action = HoverEvent.Action.SHOW_TEXT;
        private sba.sl.spectator.event.hover.Content content;

        @Override
        @NotNull
        public HoverEvent.Builder action(@NotNull HoverEvent.Action action) {
            this.action = action;
            return this;
        }

        @Override
        @NotNull
        public HoverEvent.Builder content(@NotNull sba.sl.spectator.event.hover.Content content) {
            this.content = content;
            return this;
        }

        @Override
        @NotNull
        public sba.sl.spectator.event.HoverEvent build() {
            Preconditions.checkNotNull(this.content, "Content of HoverEvent must be specified");
            if (BungeeChatFeature.MODERN_HOVER_CONTENTS.isSupported()) {
                return new BungeeHoverEvent(new HoverEvent(HoverEvent.Action.valueOf((String)this.action.name()), List.of(this.content.as(Content.class))));
            }
            return new BungeeHoverEvent(new HoverEvent(HoverEvent.Action.valueOf((String)this.action.name()), new BaseComponent[]{this.content instanceof Component ? this.content.as(BaseComponent.class) : new TextComponent(this.content.as(String.class))}));
        }
    }
}

