/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bungee.spectator.event.hover;

import lombok.Generated;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.hover.content.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bungee.spectator.AbstractBungeeBackend;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.Tag;
import sba.sl.spectator.event.hover.ItemContent;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BungeeItemContent
extends BasicWrapper<Item>
implements ItemContent {
    public BungeeItemContent(@NotNull Item wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public ResourceLocation id() {
        String id = ((Item)this.wrappedObject).getId();
        if (id == null) {
            return ResourceLocation.of("minecraft:air");
        }
        return ResourceLocation.of(id);
    }

    @Override
    @NotNull
    public ItemContent withId(@NotNull ResourceLocation id) {
        return new BungeeItemContent(new Item(id.asString(), ((Item)this.wrappedObject).getCount(), ((Item)this.wrappedObject).getTag()));
    }

    @Override
    public int count() {
        return ((Item)this.wrappedObject).getCount();
    }

    @Override
    @NotNull
    public ItemContent withCount(int count) {
        return new BungeeItemContent(new Item(((Item)this.wrappedObject).getId(), count, ((Item)this.wrappedObject).getTag()));
    }

    @Override
    @Nullable
    public CompoundTag tag() {
        ItemTag tag = ((Item)this.wrappedObject).getTag();
        if (tag == null) {
            return null;
        }
        Tag compound = AbstractBungeeBackend.getSnbtSerializer().deserialize(tag.getNbt());
        if (compound instanceof CompoundTag) {
            return (CompoundTag)compound;
        }
        return null;
    }

    @Override
    @NotNull
    public ItemContent withTag(@Nullable CompoundTag tag) {
        return new BungeeItemContent(new Item(((Item)this.wrappedObject).getId(), ((Item)this.wrappedObject).getCount(), tag != null ? ItemTag.ofNbt((String)AbstractBungeeBackend.getSnbtSerializer().serialize(tag)) : null));
    }

    @Override
    public @NotNull ItemContent.Builder toBuilder() {
        return new BungeeItemContentBuilder(this.id(), this.count(), this.tag());
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        try {
            return super.as(type);
        }
        catch (Throwable ignored) {
            return AbstractBungeeBackend.getAdditionalItemContentConverter().convert(this, type);
        }
    }

    public static class BungeeItemContentBuilder
    implements ItemContent.Builder {
        @Nullable
        private ResourceLocation id;
        private int count = 1;
        @Nullable
        private CompoundTag tag;

        @Override
        @NotNull
        public ItemContent build() {
            return new BungeeItemContent(new Item(this.id != null ? this.id.asString() : "minecraft:air", this.count, this.tag != null ? ItemTag.ofNbt((String)AbstractBungeeBackend.getSnbtSerializer().serialize(this.tag)) : null));
        }

        @Generated
        public BungeeItemContentBuilder() {
        }

        @Generated
        public BungeeItemContentBuilder(@Nullable ResourceLocation id, int count, @Nullable CompoundTag tag) {
            this.id = id;
            this.count = count;
            this.tag = tag;
        }

        @Override
        @Generated
        public BungeeItemContentBuilder id(@Nullable ResourceLocation id) {
            this.id = id;
            return this;
        }

        @Override
        @Generated
        public BungeeItemContentBuilder count(int count) {
            this.count = count;
            return this;
        }

        @Override
        @Generated
        public BungeeItemContentBuilder tag(@Nullable CompoundTag tag) {
            this.tag = tag;
            return this;
        }
    }
}

