/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.entity.type;

import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.e.type.EntityType;
import sba.sl.impl.tags.TagPortHelper;

@ApiStatus.Internal
public final class EntityTypeTagBackPorts {
    public static @Nullable List<@NotNull String> getPortedTags(@NotNull EntityType entityType, @NotNull @NotNull Predicate<@NotNull String> nativeTagChecker, boolean platformSupportsTags) {
        TagPortHelper helper = new TagPortHelper(nativeTagChecker);
        if (!Server.isVersion(1, 14) || !platformSupportsTags) {
            if (entityType.is("skeleton", "stray", "wither_skeleton")) {
                helper.port("skeletons");
            }
            if (entityType.is("evoker", "illusioner", "vindicator", "witch")) {
                helper.port("raiders");
            }
        }
        if (!(Server.isVersion(1, 15) && platformSupportsTags || !entityType.is("arrow", "spectral_arrow"))) {
            helper.port("arrows");
        }
        if (!(Server.isVersion(1, 16) && platformSupportsTags || !helper.hasTag("arrows") && !entityType.is("snowball", "fireball", "small_fireball", "egg", "trident", "dragon_fireball", "wither_skull"))) {
            helper.port("impact_projectiles");
        }
        return helper.getPorts();
    }

    @Generated
    private EntityTypeTagBackPorts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

