/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import sba.sl.nbt.ByteArrayTag;
import sba.sl.nbt.ByteTag;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.DoubleTag;
import sba.sl.nbt.FloatTag;
import sba.sl.nbt.IntArrayTag;
import sba.sl.nbt.IntTag;
import sba.sl.nbt.ListTag;
import sba.sl.nbt.LongArrayTag;
import sba.sl.nbt.LongTag;
import sba.sl.nbt.ShortTag;
import sba.sl.nbt.StringTag;
import sba.sl.nbt.Tag;

public class NBTSerializer {
    @NotNull
    public static final NBTSerializer INSTANCE = new NBTSerializer();

    public byte @NotNull [] serializeNetworking1_20_2(@NotNull Tag tag) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buf);
        this.writeType(tag, output);
        this.write(tag, output);
        return buf.toByteArray();
    }

    public byte @NotNull [] serialize(@NotNull Tag tag) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buf);
        this.writeType(tag, output);
        output.writeUTF("");
        this.write(tag, output);
        return buf.toByteArray();
    }

    public byte @NotNull [] serialize(@NotNull Tag tag, @NotNull String name) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buf);
        this.writeType(tag, output);
        output.writeUTF(name);
        this.write(tag, output);
        return buf.toByteArray();
    }

    private byte getId(@NotNull Tag tag) {
        if (tag instanceof ByteArrayTag) {
            return 7;
        }
        if (tag instanceof ByteTag) {
            return 1;
        }
        if (tag instanceof CompoundTag) {
            return 10;
        }
        if (tag instanceof DoubleTag) {
            return 6;
        }
        if (tag instanceof FloatTag) {
            return 5;
        }
        if (tag instanceof IntArrayTag) {
            return 11;
        }
        if (tag instanceof IntTag) {
            return 3;
        }
        if (tag instanceof ListTag) {
            return 9;
        }
        if (tag instanceof LongArrayTag) {
            return 12;
        }
        if (tag instanceof LongTag) {
            return 4;
        }
        if (tag instanceof ShortTag) {
            return 2;
        }
        if (tag instanceof StringTag) {
            return 8;
        }
        return -1;
    }

    private void writeType(@NotNull Tag tag, @NotNull DataOutput output) throws IOException {
        byte id = this.getId(tag);
        if (id == -1) {
            throw new IllegalArgumentException("Unknown tag " + String.valueOf(tag));
        }
        output.writeByte(id);
    }

    private void write(@NotNull Tag tag, @NotNull DataOutput output) throws IOException {
        if (tag instanceof ByteArrayTag) {
            byte[] bytes = ((ByteArrayTag)tag).value();
            output.writeInt(bytes.length);
            output.write(bytes);
        } else if (tag instanceof ByteTag) {
            output.writeByte(((ByteTag)tag).value());
        } else if (tag instanceof CompoundTag) {
            for (Map.Entry<String, Tag> entry : ((CompoundTag)tag).value().entrySet()) {
                this.writeType(entry.getValue(), output);
                output.writeUTF(entry.getKey());
                this.write(entry.getValue(), output);
            }
            output.writeByte(0);
        } else if (tag instanceof DoubleTag) {
            output.writeDouble(((DoubleTag)tag).value());
        } else if (tag instanceof FloatTag) {
            output.writeFloat(((FloatTag)tag).value());
        } else if (tag instanceof IntArrayTag) {
            int[] ints = ((IntArrayTag)tag).value();
            output.writeInt(ints.length);
            for (int intValue : ints) {
                output.writeInt(intValue);
            }
        } else if (tag instanceof IntTag) {
            output.writeInt(((IntTag)tag).value());
        } else if (tag instanceof ListTag) {
            List<Tag> values = ((ListTag)tag).value();
            if (values.isEmpty()) {
                output.writeByte(0);
                output.writeInt(0);
            } else {
                byte id = this.getId(values.get(0));
                output.writeByte(id);
                output.writeInt(values.size());
                for (Tag value : values) {
                    if (this.getId(value) == id) {
                        this.write(value, output);
                        continue;
                    }
                    throw new IllegalArgumentException("Only one kind of tag can be saved in a list!");
                }
            }
        } else if (tag instanceof LongArrayTag) {
            long[] longs = ((LongArrayTag)tag).value();
            output.writeInt(longs.length);
            for (long longValue : longs) {
                output.writeLong(longValue);
            }
        } else if (tag instanceof LongTag) {
            output.writeLong(((LongTag)tag).value());
        } else if (tag instanceof ShortTag) {
            output.writeShort(((ShortTag)tag).value());
        } else if (tag instanceof StringTag) {
            output.writeUTF(((StringTag)tag).value());
        } else {
            throw new IllegalArgumentException("Unknown tag " + String.valueOf(tag));
        }
    }

    @NotNull
    public Tag deserialize(byte @NotNull [] bytes) throws IOException {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
        byte id = input.readByte();
        input.skipBytes(input.readUnsignedShort());
        return this.read(input, id);
    }

    @NotNull
    private Tag read(@NotNull DataInputStream stream, byte id) throws IOException {
        switch (id) {
            case 1: {
                return new ByteTag(stream.readByte());
            }
            case 2: {
                return new ShortTag(stream.readShort());
            }
            case 3: {
                return new IntTag(stream.readInt());
            }
            case 4: {
                return new LongTag(stream.readLong());
            }
            case 5: {
                return new FloatTag(stream.readFloat());
            }
            case 6: {
                return new DoubleTag(stream.readDouble());
            }
            case 7: {
                return new ByteArrayTag(stream.readNBytes(stream.readInt()));
            }
            case 8: {
                return new StringTag(stream.readUTF());
            }
            case 9: {
                byte typeId = stream.readByte();
                int size = stream.readInt();
                if (typeId != 0) {
                    ArrayList<Tag> list = new ArrayList<Tag>();
                    for (int i = 0; i < size; ++i) {
                        list.add(this.read(stream, typeId));
                    }
                    return new ListTag(list);
                }
                return new ListTag(List.of());
            }
            case 10: {
                byte typeId;
                HashMap<String, Tag> map = new HashMap<String, Tag>();
                while ((typeId = stream.readByte()) != 0) {
                    String name = stream.readUTF();
                    Tag tag = this.read(stream, typeId);
                    map.put(name, tag);
                }
                return new CompoundTag(map);
            }
            case 11: {
                int[] ints = new int[stream.readInt()];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = stream.readInt();
                }
                return new IntArrayTag(ints);
            }
            case 12: {
                long[] longs = new long[stream.readInt()];
                for (int i = 0; i < longs.length; ++i) {
                    longs[i] = stream.readLong();
                }
                return new LongArrayTag(longs);
            }
        }
        throw new IllegalArgumentException("Unknown tag type " + id);
    }
}

