/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.resolvers;

import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.SNBTSerializer;
import sba.sl.nbt.Tag;
import sba.sl.spectator.Component;
import sba.sl.spectator.event.ClickEvent;
import sba.sl.spectator.event.click.Payload;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.resolvers.StylingResolver;
import sba.sl.u.ResourceLocation;

public class ClickResolver
implements StylingResolver {
    @NotNull
    private static final SNBTSerializer internalSNBTSerializer = SNBTSerializer.builder().shouldSaveLongArraysDirectly(true).build();

    @Override
    public <B extends Component.Builder<B, C>, C extends Component> void applyStyle(@NotNull MiniMessageParser parser, @NotNull B builder, @NotNull TagNode tag, Placeholder ... placeholders) {
        if (tag.getArgs().size() < 2) {
            return;
        }
        ClickEvent.Action action = ClickEvent.Action.valueOf(tag.getArgs().get(0).toUpperCase(Locale.ROOT));
        if (action == ClickEvent.Action.CUSTOM) {
            ResourceLocation id = ResourceLocation.of(tag.getArgs().get(1));
            Tag payload = tag.getArgs().size() > 2 ? internalSNBTSerializer.deserialize(tag.getArgs().get(2)) : CompoundTag.EMPTY;
            builder.clickEvent(ClickEvent.custom(id, payload));
        } else if (action != ClickEvent.Action.SHOW_DIALOG) {
            builder.clickEvent(ClickEvent.builder().action(action).payload(Payload.text(parser.resolvePlaceholdersInString(tag.getArgs().get(1), placeholders))).build());
        }
    }

    @Override
    @Nullable
    public TagNode serialize(@NotNull MiniMessageParser parser, @NotNull String tagName, @NotNull Component component) {
        ClickEvent click = component.clickEvent();
        if (click != null) {
            if (click.action() == ClickEvent.Action.CUSTOM) {
                Payload payload = click.payload();
                if (!(payload instanceof Payload.Custom)) {
                    return null;
                }
                return new TagNode(tagName, List.of(click.action().name().toLowerCase(Locale.ROOT), ((Payload.Custom)payload).location().toString(), internalSNBTSerializer.serialize(((Payload.Custom)payload).tag())));
            }
            if (click.action() != ClickEvent.Action.SHOW_DIALOG) {
                String value;
                if (click.payload() instanceof Payload.Text) {
                    value = ((Payload.Text)click.payload()).text();
                } else if (click.payload() instanceof Payload.Int) {
                    value = String.valueOf(((Payload.Int)click.payload()).number());
                } else {
                    return null;
                }
                return new TagNode(tagName, List.of(click.action().name().toLowerCase(Locale.ROOT), value));
            }
        }
        return null;
    }
}

