/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.resolvers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.resolvers.StylingResolver;

public class TransitionResolver
implements StylingResolver {
    @Override
    public <B extends Component.Builder<B, C>, C extends Component> void applyStyle(@NotNull MiniMessageParser parser, @NotNull B builder, @NotNull TagNode tag, Placeholder ... placeholders) {
        boolean negativePhase;
        List<Object> colors;
        float phase = 0.0f;
        Iterator<String> args = tag.getArgs().iterator();
        if (args.hasNext()) {
            colors = new ArrayList();
            while (args.hasNext()) {
                String value = args.next();
                if (!args.hasNext()) {
                    try {
                        phase = (float)Double.parseDouble(value);
                        if (phase < -1.0f || phase > 1.0f) {
                            return;
                        }
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                colors.add(Color.hexOrName(value));
            }
            if (colors.size() < 2) {
                return;
            }
        } else {
            colors = List.of(Color.WHITE, Color.BLACK);
        }
        boolean bl = negativePhase = phase < 0.0f;
        if (negativePhase) {
            phase += 1.0f;
            Collections.reverse(colors);
        }
        Color color = (Color)colors.get(0);
        float steps = 1.0f / (float)(colors.size() - 1);
        for (int colorIndex = 1; colorIndex < colors.size(); ++colorIndex) {
            float val = (float)colorIndex * steps;
            if (!(val >= phase)) continue;
            float factor = 1.0f + (phase - val) * (float)(colors.size() - 1);
            color = negativePhase ? Color.interpolate(1.0f - factor, (Color)colors.get(colorIndex), (Color)colors.get(colorIndex - 1)) : Color.interpolate(factor, (Color)colors.get(colorIndex - 1), (Color)colors.get(colorIndex));
        }
        builder.color(color);
    }
}

