/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.sound;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import sba.sl.api.Wrapper;
import sba.sl.impl.spectator.Spectator;
import sba.sl.impl.spectator.sound.SoundSourceLink;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

public interface SoundSource
extends Wrapper,
RawValueHolder {
    @NotNull
    public static final SoundSource MASTER = new SoundSourceLink("master");
    @NotNull
    public static final SoundSource MUSIC = new SoundSourceLink("music");
    @NotNull
    public static final SoundSource RECORD = new SoundSourceLink("record");
    @NotNull
    public static final SoundSource WEATHER = new SoundSourceLink("weather");
    @NotNull
    public static final SoundSource BLOCK = new SoundSourceLink("block");
    @NotNull
    public static final SoundSource HOSTILE = new SoundSourceLink("hostile");
    @NotNull
    public static final SoundSource NEUTRAL = new SoundSourceLink("neutral");
    @NotNull
    public static final SoundSource PLAYER = new SoundSourceLink("player");
    @NotNull
    public static final SoundSource AMBIENT = new SoundSourceLink("ambient");
    @NotNull
    public static final SoundSource VOICE = new SoundSourceLink("voice");
    @LimitedVersionSupport(value=">= 1.21.6; defaults to MASTER on older versions")
    @NotNull
    public static final SoundSource UI = new SoundSourceLink("ui");

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SoundSource soundSource(@NotNull String source) {
        return Spectator.getBackend().soundSource(source);
    }

    @NotNull
    public String name();
}

