/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.t;

import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.t.DefaultThreads;
import sba.sl.t.TaskerTime;
import sba.sl.t.ThreadProperty;
import sba.sl.t.task.Task;
import sba.sl.t.task.TaskBase;
import sba.sl.u.Pair;
import sba.sl.u.annotations.ProvidedService;

@ProvidedService
public abstract class Tasker {
    @Nullable
    private static Tasker instance;

    @ApiStatus.Internal
    protected Tasker() {
        if (instance != null) {
            throw new UnsupportedOperationException("Tasker is already initialized!");
        }
        instance = this;
    }

    @NotNull
    public static Task run(@NotNull ThreadProperty property, @NotNull Runnable runnable) {
        if (instance == null) {
            throw new UnsupportedOperationException("Tasker is not initialized yet!");
        }
        return instance.run0(property, runnable);
    }

    @NotNull
    public static Task runAsync(@NotNull Runnable runnable) {
        return Tasker.run(DefaultThreads.ASYNC_THREAD, runnable);
    }

    @NotNull
    public static Task runDelayed(@NotNull ThreadProperty property, @NotNull Runnable runnable, long delay, @NotNull TaskerTime delayUnit) {
        if (instance == null) {
            throw new UnsupportedOperationException("Tasker is not initialized yet!");
        }
        return instance.runDelayed0(property, runnable, delay, delayUnit);
    }

    @NotNull
    public static Task runDelayed(@NotNull ThreadProperty property, @NotNull Runnable runnable, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> delay) {
        return Tasker.runDelayed(property, runnable, delay.first(), delay.second());
    }

    @NotNull
    public static Task runAsyncDelayed(@NotNull Runnable runnable, long delay, @NotNull TaskerTime delayUnit) {
        return Tasker.runDelayed(DefaultThreads.ASYNC_THREAD, runnable, delay, delayUnit);
    }

    @NotNull
    public static Task runAsyncDelayed(@NotNull Runnable runnable, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> delay) {
        return Tasker.runDelayed(DefaultThreads.ASYNC_THREAD, runnable, delay.first(), delay.second());
    }

    @NotNull
    public static Task runRepeatedly(@NotNull ThreadProperty property, @NotNull Runnable runnable, long period, @NotNull TaskerTime periodUnit) {
        if (instance == null) {
            throw new UnsupportedOperationException("Tasker is not initialized yet!");
        }
        return instance.runRepeatedly0(property, runnable, period, periodUnit);
    }

    @NotNull
    public static Task runRepeatedly(@NotNull ThreadProperty property, @NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, long period, @NotNull TaskerTime periodUnit) {
        if (instance == null) {
            throw new UnsupportedOperationException("Tasker is not initialized yet!");
        }
        return instance.runRepeatedly0(property, selfCancellable, period, periodUnit);
    }

    @NotNull
    public static Task runRepeatedly(@NotNull ThreadProperty property, @NotNull Runnable runnable, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> period) {
        return Tasker.runRepeatedly(property, runnable, (long)period.first(), period.second());
    }

    @NotNull
    public static Task runRepeatedly(@NotNull ThreadProperty property, @NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> period) {
        return Tasker.runRepeatedly(property, selfCancellable, (long)period.first(), period.second());
    }

    @NotNull
    public static Task runAsyncRepeatedly(@NotNull Runnable runnable, long period, @NotNull TaskerTime periodUnit) {
        return Tasker.runRepeatedly((ThreadProperty)DefaultThreads.ASYNC_THREAD, runnable, period, periodUnit);
    }

    @NotNull
    public static Task runAsyncRepeatedly(@NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, long period, @NotNull TaskerTime periodUnit) {
        return Tasker.runRepeatedly((ThreadProperty)DefaultThreads.ASYNC_THREAD, selfCancellable, period, periodUnit);
    }

    @NotNull
    public static Task runAsyncRepeatedly(@NotNull Runnable runnable, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> period) {
        return Tasker.runRepeatedly((ThreadProperty)DefaultThreads.ASYNC_THREAD, runnable, (long)period.first(), period.second());
    }

    @NotNull
    public static Task runAsyncRepeatedly(@NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> period) {
        return Tasker.runRepeatedly((ThreadProperty)DefaultThreads.ASYNC_THREAD, selfCancellable, (long)period.first(), period.second());
    }

    @NotNull
    public static Task runDelayedAndRepeatedly(@NotNull ThreadProperty property, @NotNull Runnable runnable, long delay, @NotNull TaskerTime delayUnit, long period, @NotNull TaskerTime periodUnit) {
        if (instance == null) {
            throw new UnsupportedOperationException("Tasker is not initialized yet!");
        }
        return instance.runDelayedAndRepeatedly0(property, runnable, delay, delayUnit, period, periodUnit);
    }

    @NotNull
    public static Task runDelayedAndRepeatedly(@NotNull ThreadProperty property, @NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, long delay, @NotNull TaskerTime delayUnit, long period, @NotNull TaskerTime periodUnit) {
        if (instance == null) {
            throw new UnsupportedOperationException("Tasker is not initialized yet!");
        }
        return instance.runDelayedAndRepeatedly0(property, selfCancellable, delay, delayUnit, period, periodUnit);
    }

    @NotNull
    public static Task runDelayedAndRepeatedly(@NotNull ThreadProperty property, @NotNull Runnable runnable, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> delay, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> period) {
        return Tasker.runDelayedAndRepeatedly(property, runnable, (long)delay.first(), delay.second(), (long)period.first(), period.second());
    }

    @NotNull
    public static Task runDelayedAndRepeatedly(@NotNull ThreadProperty property, @NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> delay, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> period) {
        return Tasker.runDelayedAndRepeatedly(property, selfCancellable, (long)delay.first(), delay.second(), (long)period.first(), period.second());
    }

    @NotNull
    public static Task runAsyncDelayedAndRepeatedly(@NotNull Runnable runnable, long delay, @NotNull TaskerTime delayUnit, long period, @NotNull TaskerTime periodUnit) {
        return Tasker.runDelayedAndRepeatedly((ThreadProperty)DefaultThreads.ASYNC_THREAD, runnable, delay, delayUnit, period, periodUnit);
    }

    @NotNull
    public static Task runAsyncDelayedAndRepeatedly(@NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, long delay, @NotNull TaskerTime delayUnit, long period, @NotNull TaskerTime periodUnit) {
        return Tasker.runDelayedAndRepeatedly((ThreadProperty)DefaultThreads.ASYNC_THREAD, selfCancellable, delay, delayUnit, period, periodUnit);
    }

    @NotNull
    public static Task runAsyncDelayedAndRepeatedly(@NotNull Runnable runnable, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> delay, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> period) {
        return Tasker.runDelayedAndRepeatedly((ThreadProperty)DefaultThreads.ASYNC_THREAD, runnable, (long)delay.first(), delay.second(), (long)period.first(), period.second());
    }

    @NotNull
    public static Task runAsyncDelayedAndRepeatedly(@NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> delay, @NotNull @NotNull Pair<@NotNull Long, @NotNull TaskerTime> period) {
        return Tasker.runDelayedAndRepeatedly((ThreadProperty)DefaultThreads.ASYNC_THREAD, selfCancellable, (long)delay.first(), delay.second(), (long)period.first(), period.second());
    }

    @NotNull
    protected abstract Task run0(@NotNull ThreadProperty var1, @NotNull Runnable var2);

    @NotNull
    protected abstract Task runDelayed0(@NotNull ThreadProperty var1, @NotNull Runnable var2, long var3, @NotNull TaskerTime var5);

    @NotNull
    protected abstract Task runRepeatedly0(@NotNull ThreadProperty var1, @NotNull Runnable var2, long var3, @NotNull TaskerTime var5);

    @NotNull
    protected abstract Task runRepeatedly0(@NotNull ThreadProperty var1, @NotNull @NotNull Consumer<@NotNull TaskBase> var2, long var3, @NotNull TaskerTime var5);

    @NotNull
    protected abstract Task runDelayedAndRepeatedly0(@NotNull ThreadProperty var1, @NotNull Runnable var2, long var3, @NotNull TaskerTime var5, long var6, @NotNull TaskerTime var8);

    @NotNull
    protected abstract Task runDelayedAndRepeatedly0(@NotNull ThreadProperty var1, @NotNull @NotNull Consumer<@NotNull TaskBase> var2, long var3, @NotNull TaskerTime var5, long var6, @NotNull TaskerTime var8);
}

