/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.u.math;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.u.math.Vector3D;

public class Vector3Df
implements Cloneable {
    private float x;
    private float y;
    private float z;

    public Vector3Df clone() {
        return new Vector3Df(this.x, this.y, this.z);
    }

    public Vector3Df invert() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3Df add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3Df add(Vector3Df vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    public Vector3Df subtract(float x, float y, float z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3Df subtract(Vector3Df vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    public Vector3Df multiply(float multiply) {
        this.x *= multiply;
        this.y *= multiply;
        this.z *= multiply;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distance(@NotNull Vector3Df o) {
        return (float)Math.sqrt(this.distanceSquared(o));
    }

    public float distanceSquared(@NotNull Vector3Df o) {
        float deltaX = this.x - o.x;
        float deltaY = this.y - o.y;
        float deltaZ = this.z - o.z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    @NotNull
    public Vector3Df normalize() {
        float length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    @NotNull
    public Vector3D toVector3D() {
        return new Vector3D(this.x, this.y, this.z);
    }

    @Generated
    public float getX() {
        return this.x;
    }

    @Generated
    public float getY() {
        return this.y;
    }

    @Generated
    public float getZ() {
        return this.z;
    }

    @Generated
    public void setX(float x) {
        this.x = x;
    }

    @Generated
    public void setY(float y) {
        this.y = y;
    }

    @Generated
    public void setZ(float z) {
        this.z = z;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vector3Df)) {
            return false;
        }
        Vector3Df other = (Vector3Df)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        return Float.compare(this.getZ(), other.getZ()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Vector3Df;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getZ());
        return result;
    }

    @Generated
    public String toString() {
        return "Vector3Df(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    @Generated
    public Vector3Df() {
    }

    @Generated
    public Vector3Df(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

