/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.vi;

import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import sba.sl.pa.Player;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.vi.UpdateStrategy;

public interface Visual<T> {
    @NotNull
    public UUID uuid();

    @NotNull
    public @NotNull Collection<@NotNull Player> viewers();

    @Contract(value="-> this")
    @NotNull
    default public T update() {
        return this.update(UpdateStrategy.ALL);
    }

    @Contract(value="_ -> this")
    @NotNull
    public T update(@NotNull UpdateStrategy var1);

    @Contract(value="-> this")
    @NotNull
    public T show();

    @Contract(value="-> this")
    @NotNull
    public T hide();

    @Contract(value="_ -> this")
    @NotNull
    public T addViewer(@NotNull Player var1);

    @Contract(value="_ -> this")
    @NotNull
    public T removeViewer(@NotNull Player var1);

    @Contract(value="-> this")
    @NotNull
    public T clearViewers();

    @Contract(value="_ -> this")
    @NotNull
    public T title(@NotNull Component var1);

    @Contract(value="_ -> this")
    @NotNull
    public T title(@NotNull ComponentLike var1);

    public boolean hasViewers();

    public boolean shown();

    public void destroy();

    public boolean destroyed();

    public boolean visibleTo(@NotNull Player var1);

    public void onViewerAdded(@NotNull Player var1, boolean var2);

    public void onViewerRemoved(@NotNull Player var1, boolean var2);

    default public void onViewerAdded(@NotNull Player viewer) {
        this.onViewerAdded(viewer, false);
    }

    default public void onViewerRemoved(@NotNull Player viewer) {
        this.onViewerRemoved(viewer, false);
    }
}

