/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba;

import io.github.pronze.lib.pronzelib.scoreboards.ScoreboardManager;
import io.github.pronze.sba.AddonAPI;
import io.github.pronze.sba.UpdateChecker;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.IConfigurator;
import io.github.pronze.sba.config.QuickBuyConfig;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.fix.BaseFix;
import io.github.pronze.sba.fix.BungeecordNPC;
import io.github.pronze.sba.fix.CitizensFix;
import io.github.pronze.sba.fix.MagmaFix;
import io.github.pronze.sba.fix.MohistFix;
import io.github.pronze.sba.fix.PerWorldPluginFix;
import io.github.pronze.sba.fix.SLib203Fix;
import io.github.pronze.sba.fix.ViaVersionFix;
import io.github.pronze.sba.fix.WoolFix;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IGameStorage;
import io.github.pronze.sba.game.tasks.GameTaskManager;
import io.github.pronze.sba.inventories.GamesInventory;
import io.github.pronze.sba.inventories.SBAStoreInventoryV2;
import io.github.pronze.sba.lang.ILanguageService;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.listener.BedWarsListener;
import io.github.pronze.sba.listener.BedwarsCustomMessageModifierListener;
import io.github.pronze.sba.listener.ExplosionVelocityControlListener;
import io.github.pronze.sba.listener.GameChatListener;
import io.github.pronze.sba.listener.GameModeListener;
import io.github.pronze.sba.listener.GeneratorSplitterListener;
import io.github.pronze.sba.listener.PacketListener;
import io.github.pronze.sba.listener.PartyListener;
import io.github.pronze.sba.listener.PlayerListener;
import io.github.pronze.sba.listener.SpawnerProtectionListener;
import io.github.pronze.sba.manager.IArenaManager;
import io.github.pronze.sba.manager.IPartyManager;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.placeholderapi.SBAExpansion;
import io.github.pronze.sba.service.AIService;
import io.github.pronze.sba.service.AntiCheatIntegration;
import io.github.pronze.sba.service.DynamicSpawnerLimiterService;
import io.github.pronze.sba.service.GamesInventoryService;
import io.github.pronze.sba.service.HealthIndicatorService;
import io.github.pronze.sba.service.NPCStoreService;
import io.github.pronze.sba.service.PlayerWrapperService;
import io.github.pronze.sba.service.WrapperService;
import io.github.pronze.sba.specials.SpawnerProtection;
import io.github.pronze.sba.specials.listener.BridgeEggListener;
import io.github.pronze.sba.specials.listener.PopupTowerListener;
import io.github.pronze.sba.utils.DateUtils;
import io.github.pronze.sba.utils.FirstStartConfigReplacer;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.MessageUtils;
import io.github.pronze.sba.utils.citizens.FakeDeathTrait;
import io.github.pronze.sba.utils.citizens.HologramTrait;
import io.github.pronze.sba.utils.citizens.ReturnToStoreTrait;
import io.github.pronze.sba.visuals.LobbyScoreboardManager;
import io.github.pronze.sba.visuals.MainLobbyVisualsManager;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.BedwarsAPI;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.lib.bstats.bukkit.Metrics;
import org.screamingsandals.bedwars.lib.sgui.listeners.InventoryListener;
import sba.si.SimpleInventoriesCore;
import sba.sl.ev.EventManager;
import sba.sl.h.HologramManager;
import sba.sl.hi.HealthIndicatorManager2;
import sba.sl.npc.NPCManager;
import sba.sl.p.PacketMapper;
import sba.sl.pa.Players;
import sba.sl.pu.Plugin;
import sba.sl.si.SidebarManager;
import sba.sl.u.PlatformType;
import sba.sl.u.annotations.Init;
import sba.sl.u.annotations.Plugin;
import sba.sl.u.annotations.PluginDependencies;
import sba.sl.u.annotations.methods.OnDisable;
import sba.sl.u.annotations.methods.OnEnable;
import sba.sl.u.annotations.methods.OnPostEnable;

@sba.sl.u.annotations.Plugin(id="SBA", authors={"pronze", "boiscljo"}, loadTime=Plugin.LoadTime.POSTWORLD, version="1.5.17")
@PluginDependencies(platform=PlatformType.BUKKIT, dependencies={"BedWars"}, softDependencies={"PlaceholderAPI", "ViaVersion", "Citizens", "Vulcan", "PerWorldPlugins"})
@Init(services={Logger.class, PacketMapper.class, HologramManager.class, HealthIndicatorManager2.class, SimpleInventoriesCore.class, NPCManager.class, UpdateChecker.class, SBAConfig.class, LanguageService.class, CommandManager.class, ArenaManager.class, PartyManager.class, GameTaskManager.class, SBAStoreInventoryV2.class, GamesInventory.class, PlayerWrapperService.class, GamesInventoryService.class, HealthIndicatorService.class, PacketListener.class, DateUtils.class, BedWarsListener.class, GameChatListener.class, PartyListener.class, PlayerListener.class, GeneratorSplitterListener.class, ExplosionVelocityControlListener.class, LobbyScoreboardManager.class, MainLobbyVisualsManager.class, DynamicSpawnerLimiterService.class, BedwarsCustomMessageModifierListener.class, BridgeEggListener.class, PopupTowerListener.class, NPCStoreService.class, FirstStartConfigReplacer.class, GameModeListener.class, SpawnerProtection.class, SpawnerProtectionListener.class, SidebarManager.class, AntiCheatIntegration.class, QuickBuyConfig.class})
public class SBA
implements AddonAPI {
    private static SBA instance;
    public static boolean sbw_0_2_30;
    private List<BaseFix> fixs;
    public CitizensFix citizensFix;
    private JavaPlugin cachedPluginInstance;
    private Plugin pluginDescription;
    private final List<Listener> registeredListeners = new ArrayList<Listener>();
    private Metrics metrics;
    private static boolean broken;

    public static SBA getInstance() {
        return instance;
    }

    public SBA(JavaPlugin cachedPluginInstance, Plugin pluginDescription) {
        this.cachedPluginInstance = cachedPluginInstance;
        this.pluginDescription = pluginDescription;
    }

    public static JavaPlugin getPluginInstance() {
        if (instance == null) {
            throw new UnsupportedOperationException("SBA has not yet been initialized!");
        }
        return SBA.instance.cachedPluginInstance;
    }

    @OnEnable
    public void enable() {
        instance = this;
        if (Main.getVersionNumber() < 109) {
            // empty if block
        }
        this.fixs = new ArrayList<BaseFix>();
        this.fixs.add(BungeecordNPC.getInstance());
        this.fixs.add(new MohistFix());
        this.fixs.add(new ViaVersionFix());
        this.fixs.add(new MagmaFix());
        this.fixs.add(new PerWorldPluginFix());
        this.fixs.add(new WoolFix());
        this.fixs.add(new SLib203Fix());
        this.citizensFix = new CitizensFix();
        this.fixs.add(this.citizensFix);
        for (BaseFix fix : this.fixs) {
            fix.detect();
            if (!fix.IsCritical()) continue;
            broken = true;
        }
        ScoreboardManager.init(this.cachedPluginInstance);
        int pluginId = 14804;
        this.metrics = new Metrics(this.cachedPluginInstance, pluginId);
    }

    @OnPostEnable
    public void postEnable() {
        if (Bukkit.getServer().getServicesManager().getRegistration(BedwarsAPI.class) == null) {
            MessageUtils.showErrorMessage("Could not find Screaming-BedWars plugin!, make sure you have the right one installed, and it's enabled properly!");
            Bukkit.getServer().getPluginManager().disablePlugin((org.bukkit.plugin.Plugin)SBA.getPluginInstance());
            return;
        }
        Logger.info("SBA initialized using Bedwars {}", BedwarsAPI.getInstance().getPluginVersion());
        if (!BedwarsAPI.getInstance().getPluginVersion().startsWith("0.2")) {
            Logger.error("SBA only support Bedwars version 2", new Object[0]);
            Bukkit.getServer().getPluginManager().disablePlugin((org.bukkit.plugin.Plugin)SBA.getPluginInstance());
            return;
        }
        if (!List.of("0.2.29", "0.2.30", "0.2.31", "0.2.31", "0.2.32", "0.2.32.1").stream().anyMatch(BedwarsAPI.getInstance().getPluginVersion()::equals)) {
            Logger.warn("SBA hasn't been tested on this version of Bedwars. If you encounter bugs, use version 0.2.29 to 0.2.32.1. ", new Object[0]);
        }
        sbw_0_2_30 = Integer.parseInt(BedwarsAPI.getInstance().getPluginVersion().split("[.-]")[2]) >= 30;
        for (BaseFix fix : this.fixs) {
            fix.fix(SBAConfig.getInstance());
            if (fix.IsProblematic()) {
                fix.warn();
            }
            if (!fix.IsCritical()) continue;
            broken = true;
        }
        if (!broken) {
            InventoryListener.init((org.bukkit.plugin.Plugin)this.cachedPluginInstance);
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                Logger.trace("Registering SBAExpansion...", new Object[0]);
                new SBAExpansion().register();
            }
        }
        Logger.info("Plugin has finished loading!", new Object[0]);
        this.registerAPI();
        Logger.info("SBA Initialized on JAVA {}", System.getProperty("java.version"));
        Logger.info("SBA Commit is on par with {}", "d0d4b47");
        Logger.trace("API has been registered!", new Object[0]);
        HologramManager.setPreferDisplayEntities(Main.getConfigurator().config.getBoolean("prefer-1-19-4-display-entities"));
        Logger.setMode(Logger.Level.WARNING);
        if (!broken && this.citizensFix.canEnable()) {
            CitizensTraits.enableCitizensTraits();
        }
        if (broken) {
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getServer().getPluginManager().disablePlugin((org.bukkit.plugin.Plugin)SBA.getPluginInstance());
                }
            }.runTaskLater((org.bukkit.plugin.Plugin)this.getJavaPlugin(), 20L);
        }
    }

    public void registerListener(@NotNull Listener listener) {
        if (this.registeredListeners.contains(listener)) {
            return;
        }
        Bukkit.getServer().getPluginManager().registerEvents(listener, (org.bukkit.plugin.Plugin)SBA.getPluginInstance());
        Logger.trace("Registered listener: {}", listener.getClass().getSimpleName());
    }

    public void unregisterListener(@NotNull Listener listener) {
        if (!this.registeredListeners.contains(listener)) {
            return;
        }
        HandlerList.unregisterAll((Listener)listener);
        this.registeredListeners.remove(listener);
        Logger.trace("Unregistered listener: {}", listener.getClass().getSimpleName());
    }

    public List<Listener> getRegisteredListeners() {
        return List.copyOf(this.registeredListeners);
    }

    private void registerAPI() {
        if (Bukkit.getServer().getServicesManager().getRegistration(AddonAPI.class) == null) {
            Bukkit.getServer().getServicesManager().register(AddonAPI.class, (Object)this, (org.bukkit.plugin.Plugin)this.cachedPluginInstance, ServicePriority.Normal);
        }
    }

    @OnDisable
    public void disable() {
        EventManager.getDefaultEventManager().unregisterAll();
        EventManager.getDefaultEventManager().destroy();
        Bukkit.getServer().getServicesManager().unregisterAll((org.bukkit.plugin.Plugin)SBA.getPluginInstance());
    }

    @Override
    public Optional<IGameStorage> getGameStorage(Game game) {
        return ArenaManager.getInstance().getGameStorage(game.getName());
    }

    @Override
    public SBAPlayerWrapper getPlayerWrapper(Player player) {
        return PlayerWrapperService.getInstance().get(player).orElseGet(() -> Players.wrapPlayer(player).as(SBAPlayerWrapper.class));
    }

    @Override
    public boolean isDebug() {
        return SBAConfig.getInstance().getBoolean("debug.enabled", false);
    }

    @Override
    public boolean isSnapshot() {
        return this.getVersion().contains("SNAPSHOT") || this.getVersion().contains("dev");
    }

    @Override
    public String getVersion() {
        return this.pluginDescription.version();
    }

    @Override
    public IArenaManager getArenaManager() {
        return ArenaManager.getInstance();
    }

    @Override
    public IPartyManager getPartyManager() {
        return PartyManager.getInstance();
    }

    @Override
    public WrapperService<Player, SBAPlayerWrapper> getPlayerWrapperService() {
        return PlayerWrapperService.getInstance();
    }

    @Override
    public IConfigurator getConfigurator() {
        return SBAConfig.getInstance();
    }

    @Override
    public boolean isPendingUpgrade() {
        return !this.getVersion().equalsIgnoreCase(SBAConfig.getInstance().node("version").getString());
    }

    @Override
    public ILanguageService getLanguageService() {
        return LanguageService.getInstance();
    }

    @Override
    public JavaPlugin getJavaPlugin() {
        return SBA.instance.cachedPluginInstance;
    }

    public static org.bukkit.plugin.Plugin getBedwarsPlugin() {
        return Bukkit.getPluginManager().getPlugin("BedWars");
    }

    public boolean isPendingUpdate() {
        return UpdateChecker.getInstance().isPendingUpdate();
    }

    public void update(@NotNull CommandSender sender) {
        UpdateChecker.getInstance().update(sender);
    }

    public static boolean isBroken() {
        return broken;
    }

    static {
        broken = false;
    }

    private static class CitizensTraits {
        private CitizensTraits() {
        }

        private static void enableCitizensTraits() {
            if (CitizensAPI.getTraitFactory().getTrait("SBAHologramTrait") == null) {
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(HologramTrait.class).withName("SBAHologramTrait"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ReturnToStoreTrait.class).withName("ReturnToStoreTrait"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(FakeDeathTrait.class).withName("FakeDeathTrait"));
                AIService aiService = new AIService();
                aiService.onPostEnabled();
            }
        }
    }
}

