/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import io.github.pronze.sba.game.Arena;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.IGameStorage;
import io.github.pronze.sba.manager.IArenaManager;
import io.github.pronze.sba.utils.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.api.game.Game;
import sba.sl.pu.ServiceManager;
import sba.sl.u.annotations.Service;

@Service
public class ArenaManager
implements IArenaManager {
    private final Map<String, IArena> arenaMap = new HashMap<String, IArena>();

    public static ArenaManager getInstance() {
        return ServiceManager.get(ArenaManager.class);
    }

    public List<IArena> getRegisteredArenas() {
        return List.copyOf(this.arenaMap.values());
    }

    @Override
    public IArena createArena(@NotNull Game game) {
        String gameName = game.getName();
        if (this.arenaMap.containsKey(gameName)) {
            throw new UnsupportedOperationException("Arena: " + gameName + " already exists!");
        }
        Logger.trace("Creating arena for game: {}", gameName);
        Arena arena = new Arena(game);
        this.arenaMap.put(gameName, arena);
        return arena;
    }

    @Override
    public void removeArena(@NotNull Game game) {
        Logger.trace("Removing arena for game: {}", game.getName());
        this.arenaMap.remove(game.getName());
    }

    @Override
    public Optional<IArena> get(String gameName) {
        return Optional.ofNullable(this.arenaMap.get(gameName));
    }

    @Override
    public Optional<IGameStorage> getGameStorage(String gameName) {
        if (!this.arenaMap.containsKey(gameName)) {
            return Optional.empty();
        }
        return Optional.of(this.arenaMap.get(gameName).getStorage());
    }

    public Map<String, IArena> getArenaMap() {
        return this.arenaMap;
    }
}

