/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game.tasks;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBASpawnerTierUpgradeEvent;
import io.github.pronze.sba.game.GameTierEvent;
import io.github.pronze.sba.game.GeneratorUpgradeType;
import io.github.pronze.sba.game.IRotatingGenerator;
import io.github.pronze.sba.game.RotatingGenerator;
import io.github.pronze.sba.game.tasks.BaseGameTask;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import java.util.regex.Pattern;
import javax.naming.NameNotFoundException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.screamingsandals.bedwars.api.game.ItemSpawnerType;
import org.screamingsandals.bedwars.game.Game;
import sba.sl.pa.Player;
import sba.sl.pa.Players;
import sba.sl.s.CommandSender;

public class GeneratorTask
extends BaseGameTask {
    private final double multiplier;
    private final boolean timerUpgrades;
    private final boolean showUpgradeMessage;
    private GameTierEvent nextEvent = GameTierEvent.first();
    private int elapsedTime;

    public GeneratorTask() {
        this.timerUpgrades = SBAConfig.getInstance().getBoolean("upgrades.timer-upgrades-enabled", true);
        this.showUpgradeMessage = SBAConfig.getInstance().getBoolean("upgrades.show-upgrade-message", true);
        this.multiplier = SBAConfig.getInstance().getDouble("upgrades.multiplier", 0.25);
    }

    @Override
    public void run() {
        if (this.nextEvent != GameTierEvent.GAME_END && this.elapsedTime == this.nextEvent.getTime()) {
            if (this.timerUpgrades) {
                try {
                    String tierName = this.nextEvent.getKey();
                    ItemSpawnerType upgradeType = GeneratorUpgradeType.fromString(tierName.substring(0, tierName.indexOf("-")));
                    tierName = this.getNextTierName();
                    String matName = null;
                    Material type = null;
                    type = upgradeType.getMaterial();
                    matName = upgradeType.getColor().toString() + upgradeType.getItemName();
                    boolean emptyQuery = this.game.getItemSpawners().stream().filter(itemSpawner -> itemSpawner.getItemSpawnerType() != null && itemSpawner.getItemSpawnerType().getMaterial() == upgradeType.getMaterial()).findAny().isEmpty();
                    if (emptyQuery) {
                        type = null;
                    } else {
                        this.game.getItemSpawners().forEach(itemSpawner -> {
                            if (itemSpawner.getItemSpawnerType() != null && itemSpawner.getItemSpawnerType().getMaterial() == upgradeType.getMaterial()) {
                                itemSpawner.addToCurrentLevel(this.multiplier);
                            }
                        });
                        Material finalType = type;
                        this.arena.getRotatingGenerators().stream().map(generator -> (RotatingGenerator)generator).filter(generator -> generator.getItemSpawner().getItemSpawnerType().getMaterial() == finalType).forEach(generator -> {
                            SBASpawnerTierUpgradeEvent event = new SBASpawnerTierUpgradeEvent(this.game, (IRotatingGenerator)generator);
                            Bukkit.getServer().getPluginManager().callEvent((Event)event);
                            if (event.isCancelled()) {
                                return;
                            }
                            generator.setTierLevel(generator.getTierLevel() + 1);
                        });
                        if (this.showUpgradeMessage && finalType != null) {
                            LanguageService.getInstance().get(MessageKeys.GENERATOR_UPGRADE_MESSAGE).replace("%MatName%", matName).replace("%tier%", tierName).send((CommandSender[])this.game.getConnectedPlayers().stream().map(Players::wrapPlayer).toArray(Player[]::new));
                        }
                    }
                }
                catch (NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
            this.nextEvent = this.nextEvent.getNextEvent();
        }
        ++this.elapsedTime;
    }

    public String getTimeLeftForNextEvent() {
        if (this.nextEvent == GameTierEvent.GAME_END) {
            return ((Game)this.game).getFormattedTimeLeft();
        }
        return ((Game)this.game).getFormattedTimeLeft(this.nextEvent.getTime() - this.elapsedTime);
    }

    public String getNextTierName() {
        if (this.nextEvent == GameTierEvent.GAME_END) {
            return LanguageService.getInstance().get(MessageKeys.GAME_END_MESSAGE).toString();
        }
        try {
            Object tierName = this.nextEvent.getKey();
            ItemSpawnerType upgradeType = GeneratorUpgradeType.fromString(((String)tierName).substring(0, ((String)tierName).indexOf("-")));
            Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)" + String.valueOf('\u00a7') + "[0-9A-FK-ORX]");
            tierName = STRIP_COLOR_PATTERN.matcher(upgradeType.getItemName()).replaceAll("") + "-" + ((String)tierName).split("-")[1];
            return tierName;
        }
        catch (NameNotFoundException e) {
            Logger.warn("{}", e);
            return this.nextEvent.getKey();
        }
    }
}

