/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils.citizens;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.service.AIService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.citizens.AttackNearbyPlayerGoal;
import io.github.pronze.sba.utils.citizens.AttackOtherGoal;
import io.github.pronze.sba.utils.citizens.BalancedGoal;
import io.github.pronze.sba.utils.citizens.BedwarsBlockPlace;
import io.github.pronze.sba.utils.citizens.BuildBedDefenseGoal;
import io.github.pronze.sba.utils.citizens.CancelNavigation;
import io.github.pronze.sba.utils.citizens.DontCancelBlockBreak;
import io.github.pronze.sba.utils.citizens.GatherBlocks;
import io.github.pronze.sba.utils.citizens.GatherRessource;
import io.github.pronze.sba.utils.citizens.Strategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.api.game.Game;
import sba.sl.impl.bukkit.utils.Version;

public class FakeDeathTrait
extends Trait {
    private List<AiGoal> goals = new ArrayList<AiGoal>();
    private Strategy strategy = Strategy.ANY;
    private Player oldPlayerObject = null;
    private BedwarsBlockPlace blockPlace_;
    int timer = 0;
    int timerPickup = 5;
    private Game game;

    public FakeDeathTrait() {
        super("FakeDeathTrait");
    }

    BedwarsBlockPlace blockPlace() {
        if (this.blockPlace_ != null) {
            return this.blockPlace_;
        }
        this.npc.getTraits().forEach(t -> {
            if (t instanceof BedwarsBlockPlace) {
                this.blockPlace_ = (BedwarsBlockPlace)((Object)t);
            }
        });
        return this.blockPlace_;
    }

    public Player getNpcEntity() {
        return (Player)this.npc.getEntity();
    }

    public void onSpawn() {
        if (!(this.npc.getEntity() instanceof Player)) {
            return;
        }
        try {
            Player npcEntity = (Player)this.npc.getEntity();
            if (this.oldPlayerObject != null && npcEntity != this.oldPlayerObject && this.game != null) {
                this.game.getRunningTeams().forEach(team -> {
                    if (team.isPlayerInTeam(this.oldPlayerObject)) {
                        this.game.leaveFromGame(this.oldPlayerObject);
                    }
                });
            }
            this.oldPlayerObject = npcEntity;
            npcEntity.setMetadata("FakeDeath", (MetadataValue)new FixedMetadataValue((Plugin)SBA.getPluginInstance(), (Object)true));
            Logger.trace("Initializing AI in mode{}", new Object[]{this.strategy});
            Random r = new Random();
            if (this.strategy == Strategy.ANY) {
                List<Strategy> possibilities = List.of(Strategy.AGRESSIVE, Strategy.DEFENSIVE, Strategy.BALANCED);
                this.strategy = possibilities.get(r.nextInt(possibilities.size()));
            }
            this.goals.clear();
            if (this.strategy != Strategy.NONE) {
                this.goals.add(new DontCancelBlockBreak(this));
                this.goals.add(new GatherBlocks(this));
                this.goals.add(new AttackNearbyPlayerGoal(this));
                if (this.strategy == Strategy.DEFENSIVE) {
                    this.goals.add(new BuildBedDefenseGoal(this));
                } else if (this.strategy == Strategy.AGRESSIVE) {
                    this.goals.add(new AttackOtherGoal(this));
                } else if (this.strategy == Strategy.BALANCED) {
                    this.goals.add(new BalancedGoal(this));
                }
                this.goals.add(new GatherRessource(this));
                this.goals.add(new CancelNavigation(this));
            }
        }
        catch (ClassCastException cc) {
            this.npc.removeTrait(FakeDeathTrait.class);
        }
    }

    public void onDespawn() {
    }

    public Player getPlayerObject() {
        return this.oldPlayerObject;
    }

    List<Entity> getNearbyEntities(int range) {
        return this.npc.getEntity().getNearbyEntities((double)range, (double)range, (double)range);
    }

    public void run() {
        if (this.game != null) {
            if (!this.game.isLocationInArena(this.getPlayerObject().getLocation()) && this.getPlayerObject().getGameMode() == GameMode.SURVIVAL) {
                AIService.getInstance().die(this.getPlayerObject());
            }
        } else {
            return;
        }
        if (this.timer-- <= 0) {
            this.timer = 5;
            for (AiGoal goal : this.goals) {
                if (!goal.isAvailable()) continue;
                goal.doGoal();
                break;
            }
        }
        if (this.timerPickup-- <= 0) {
            this.timerPickup = 5;
            List<Entity> entities = this.getNearbyEntities(3);
            for (Entity entity : entities) {
                Item itemEntity;
                ItemStack is;
                int space;
                if (!(entity instanceof Item) || (space = FakeDeathTrait.getAmountOfSpaceFor(is = (itemEntity = (Item)entity).getItemStack(), (Inventory)this.getNpcEntity().getInventory())) <= 0) continue;
                if (Version.isVersion(1, 12)) {
                    new Pickup112().pick(itemEntity, is, space);
                    continue;
                }
                new Pickup18().pick(itemEntity, is, space);
            }
        }
    }

    public static int getAmountOfSpaceFor(ItemStack m, Inventory inv) {
        m = new ItemStack(m);
        m.setAmount(1);
        int oneStack = new ItemStack(m).getMaxStackSize();
        int space = 0;
        ItemStack[] inventoryContent = null;
        try {
            inventoryContent = inv.getStorageContents();
        }
        catch (Throwable t) {
            inventoryContent = inv.getContents();
        }
        for (int index = 0; index < inventoryContent.length; ++index) {
            ItemStack itemStack = inventoryContent[index];
            if (itemStack != null && itemStack.getType() != Material.AIR) continue;
            space += oneStack;
        }
        HashMap inventoryStock = inv.all(m.getType());
        for (Map.Entry stack : inventoryStock.entrySet()) {
            ItemStack comparedStack = new ItemStack((ItemStack)stack.getValue());
            comparedStack.setAmount(1);
            if (!m.equals((Object)comparedStack)) continue;
            space += oneStack - ((ItemStack)stack.getValue()).getAmount();
        }
        return space;
    }

    public void joinBedwarsGame(Game game) {
        this.game = game;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public static interface AiGoal {
        public boolean isAvailable();

        public void doGoal();
    }

    class Pickup112 {
        Pickup112() {
        }

        public void pick(Item itemEntity, ItemStack is, int space) {
            EntityPickupItemEvent pickupEvent = new EntityPickupItemEvent((LivingEntity)FakeDeathTrait.this.npc.getEntity(), itemEntity, Math.max(0, is.getAmount() - space));
            Bukkit.getPluginManager().callEvent((Event)pickupEvent);
            if (!pickupEvent.isCancelled()) {
                Logger.trace("NPC Pickup {}", itemEntity.getItemStack());
                FakeDeathTrait.this.getNpcEntity().getInventory().addItem(new ItemStack[]{pickupEvent.getItem().getItemStack()});
                FakeDeathTrait.this.blockPlace().getBlock((Inventory)FakeDeathTrait.this.getNpcEntity().getInventory());
                if (pickupEvent.getRemaining() > 0) {
                    itemEntity.getItemStack().setAmount(pickupEvent.getRemaining());
                } else {
                    itemEntity.remove();
                }
            }
        }
    }

    class Pickup18 {
        Pickup18() {
        }

        public void pick(Item itemEntity, ItemStack is, int space) {
            PlayerPickupItemEvent pickupEvent = new PlayerPickupItemEvent((Player)FakeDeathTrait.this.npc.getEntity(), itemEntity, Math.max(0, is.getAmount() - space));
            Bukkit.getPluginManager().callEvent((Event)pickupEvent);
            if (!pickupEvent.isCancelled()) {
                Logger.trace("NPC Pickup {}", itemEntity.getItemStack());
                FakeDeathTrait.this.getNpcEntity().getInventory().addItem(new ItemStack[]{pickupEvent.getItem().getItemStack()});
                FakeDeathTrait.this.blockPlace().getBlock((Inventory)FakeDeathTrait.this.getNpcEntity().getInventory());
                if (pickupEvent.getRemaining() > 0) {
                    itemEntity.getItemStack().setAmount(pickupEvent.getRemaining());
                } else {
                    itemEntity.remove();
                }
            }
        }
    }
}

