/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.annotations.injection;

import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.cl.annotations.AnnotationAccessor;
import sba.cl.annotations.injection.InjectionService;
import sba.cl.annotations.injection.ParameterInjector;
import sba.cl.context.CommandContext;
import sba.cl.services.ServicePipeline;
import sba.cl.types.tuples.Triplet;

public final class ParameterInjectorRegistry<C>
implements InjectionService<C> {
    private volatile int injectorCount = 0;
    private final Map<Class<?>, List<ParameterInjector<C, ?>>> injectors = new HashMap();
    private final ServicePipeline servicePipeline = ServicePipeline.builder().build();

    public ParameterInjectorRegistry() {
        this.servicePipeline.registerServiceType(new TypeToken<InjectionService<C>>(){}, this);
    }

    public synchronized <T> void registerInjector(@NonNull Class<T> clazz, @NonNull ParameterInjector<C, T> injector) {
        this.injectors.computeIfAbsent(clazz, missingClass -> new LinkedList()).add(injector);
        ++this.injectorCount;
    }

    @Deprecated
    public synchronized <T> @NonNull Collection<@NonNull ParameterInjector<C, ?>> injectors(@NonNull Class<T> clazz) {
        ArrayList<@NonNull E> injectors = new ArrayList(this.injectorCount);
        for (Map.Entry<Class<?>, List<ParameterInjector<C, ?>>> entry : this.injectors.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey())) continue;
            injectors.addAll(entry.getValue());
        }
        return Collections.unmodifiableCollection(injectors);
    }

    @Override
    public @Nullable Object handle(@NonNull Triplet<CommandContext<C>, Class<?>, AnnotationAccessor> triplet) {
        for (ParameterInjector<C, ?> injector : this.injectors(triplet.getSecond())) {
            Object value = injector.create(triplet.getFirst(), triplet.getThird());
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public <T> @NonNull Optional<T> getInjectable(@NonNull Class<T> clazz, @NonNull CommandContext<C> context, @NonNull AnnotationAccessor annotationAccessor) {
        Triplet<CommandContext<C>, Class<T>, AnnotationAccessor> triplet = Triplet.of(context, clazz, annotationAccessor);
        try {
            return Optional.of(clazz.cast(this.servicePipeline.pump(triplet).through(new TypeToken<InjectionService<C>>(){}).getResult()));
        }
        catch (IllegalStateException illegalStateException) {
            return Optional.empty();
        }
    }

    public void registerInjectionService(InjectionService<C> service) {
        this.servicePipeline.registerServiceImplementation(new TypeToken<InjectionService<C>>(){}, service, Collections.emptyList());
    }
}

