/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.bukkit;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Constructor;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.NamespacedKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import sba.cl.arguments.parser.ArgumentParser;
import sba.cl.arguments.standard.UUIDArgument;
import sba.cl.brigadier.CloudBrigadierManager;
import sba.cl.bukkit.BukkitCommandManager;
import sba.cl.bukkit.internal.MinecraftArgumentTypes;
import sba.cl.bukkit.parsers.BlockPredicateArgument;
import sba.cl.bukkit.parsers.EnchantmentArgument;
import sba.cl.bukkit.parsers.ItemStackArgument;
import sba.cl.bukkit.parsers.ItemStackPredicateArgument;
import sba.cl.bukkit.parsers.location.Location2DArgument;
import sba.cl.bukkit.parsers.location.LocationArgument;
import sba.cl.bukkit.parsers.selector.MultipleEntitySelectorArgument;
import sba.cl.bukkit.parsers.selector.MultiplePlayerSelectorArgument;
import sba.cl.bukkit.parsers.selector.SingleEntitySelectorArgument;
import sba.cl.bukkit.parsers.selector.SinglePlayerSelectorArgument;

public final class BukkitBrigadierMapper<C> {
    private final BukkitCommandManager<C> commandManager;
    private final CloudBrigadierManager<C, ?> brigadierManager;

    public BukkitBrigadierMapper(@NonNull BukkitCommandManager<C> commandManager, @NonNull CloudBrigadierManager<C, ?> brigadierManager) {
        this.commandManager = commandManager;
        this.brigadierManager = brigadierManager;
        this.registerMappings();
    }

    private void registerMappings() {
        try {
            Class<? extends ArgumentType<?>> uuid = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"uuid"));
            this.mapSimpleNMS(new TypeToken<UUIDArgument.UUIDParser<C>>(){}, "uuid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mapSimpleNMS(new TypeToken<EnchantmentArgument.EnchantmentParser<C>>(){}, "item_enchantment");
        this.mapSimpleNMS(new TypeToken<ItemStackArgument.Parser<C>>(){}, "item_stack");
        this.mapSimpleNMS(new TypeToken<ItemStackPredicateArgument.Parser<C>>(){}, "item_predicate");
        this.mapSimpleNMS(new TypeToken<BlockPredicateArgument.Parser<C>>(){}, "block_predicate");
        this.mapNMS(new TypeToken<SingleEntitySelectorArgument.SingleEntitySelectorParser<C>>(){}, this.entitySelectorArgumentSupplier(true, false));
        this.mapNMS(new TypeToken<SinglePlayerSelectorArgument.SinglePlayerSelectorParser<C>>(){}, this.entitySelectorArgumentSupplier(true, true));
        this.mapNMS(new TypeToken<MultipleEntitySelectorArgument.MultipleEntitySelectorParser<C>>(){}, this.entitySelectorArgumentSupplier(false, false));
        this.mapNMS(new TypeToken<MultiplePlayerSelectorArgument.MultiplePlayerSelectorParser<C>>(){}, this.entitySelectorArgumentSupplier(false, true));
        this.mapNMS(new TypeToken<LocationArgument.LocationParser<C>>(){}, this::argumentVec3);
        this.mapNMS(new TypeToken<Location2DArgument.Location2DParser<C>>(){}, this::argumentVec2);
    }

    private @NonNull Supplier<ArgumentType<?>> entitySelectorArgumentSupplier(boolean single, boolean playersOnly) {
        return () -> {
            try {
                Constructor<?> constructor = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"entity")).getDeclaredConstructors()[0];
                constructor.setAccessible(true);
                return (ArgumentType)constructor.newInstance(single, playersOnly);
            }
            catch (Exception e) {
                this.commandManager.getOwningPlugin().getLogger().log(Level.INFO, "Failed to retrieve Selector Argument", e);
                return BukkitBrigadierMapper.fallbackType();
            }
        };
    }

    private @NonNull ArgumentType<?> argumentVec3() {
        try {
            return MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"vec3")).getDeclaredConstructor(Boolean.TYPE).newInstance(true);
        }
        catch (Exception e) {
            this.commandManager.getOwningPlugin().getLogger().log(Level.INFO, "Failed to retrieve Vec3D argument", e);
            return BukkitBrigadierMapper.fallbackType();
        }
    }

    private @NonNull ArgumentType<?> argumentVec2() {
        try {
            return MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"vec2")).getDeclaredConstructor(Boolean.TYPE).newInstance(true);
        }
        catch (Exception e) {
            this.commandManager.getOwningPlugin().getLogger().log(Level.INFO, "Failed to retrieve Vec2 argument", e);
            return BukkitBrigadierMapper.fallbackType();
        }
    }

    public <T extends ArgumentParser<C, ?>> void mapSimpleNMS(@NonNull TypeToken<T> type, @NonNull String argumentId) {
        this.mapSimpleNMS(type, argumentId, false);
    }

    public <T extends ArgumentParser<C, ?>> void mapSimpleNMS(@NonNull TypeToken<T> type, @NonNull String argumentId, boolean useCloudSuggestions) {
        Constructor<? extends ArgumentType<?>> constructor;
        try {
            Class<ArgumentType<?>> nmsArgument = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)argumentId));
            constructor = nmsArgument.getConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            this.commandManager.getOwningPlugin().getLogger().log(Level.WARNING, String.format("Failed to create mapping for NMS brigadier argument type '%s'.", argumentId), e);
            return;
        }
        this.brigadierManager.registerMapping(type, builder -> {
            builder.to(argument -> {
                try {
                    return (ArgumentType)constructor.newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    this.commandManager.getOwningPlugin().getLogger().log(Level.WARNING, String.format("Failed to create instance of brigadier argument type '%s'.", GenericTypeReflector.erase(type.getType()).getCanonicalName()), e);
                    return BukkitBrigadierMapper.fallbackType();
                }
            });
            if (useCloudSuggestions) {
                builder.cloudSuggestions();
            }
        });
    }

    public <T extends ArgumentParser<C, ?>> void mapNMS(@NonNull TypeToken<T> type, @NonNull Supplier<ArgumentType<?>> argumentTypeSupplier) {
        this.brigadierManager.registerMapping(type, builder -> builder.to(arg_0 -> BukkitBrigadierMapper.lambda$mapNMS$3((Supplier)argumentTypeSupplier, arg_0)));
    }

    private static @NonNull StringArgumentType fallbackType() {
        return StringArgumentType.word();
    }

    @Deprecated
    public void mapSimpleNMS(@NonNull Class<?> type, @NonNull Constructor<?> constructor) {
        this.brigadierManager.registerDefaultArgumentTypeSupplier(type, () -> {
            try {
                return (ArgumentType)constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                this.commandManager.getOwningPlugin().getLogger().log(Level.WARNING, String.format("Failed to map brigadier argument type '%s'", type.getCanonicalName()), e);
                return BukkitBrigadierMapper.fallbackType();
            }
        });
    }

    @Deprecated
    public void mapComplexNMS(@NonNull Class<?> type, @NonNull Supplier<ArgumentType<?>> argumentTypeSupplier) {
        this.brigadierManager.registerDefaultArgumentTypeSupplier(type, argumentTypeSupplier);
    }

    private static /* synthetic */ ArgumentType lambda$mapNMS$3(Supplier argumentTypeSupplier, ArgumentParser argument) {
        return (ArgumentType)argumentTypeSupplier.get();
    }
}

