/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.bukkit.parsers.selector;

import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.cl.ArgumentDescription;
import sba.cl.arguments.CommandArgument;
import sba.cl.arguments.parser.ArgumentParseResult;
import sba.cl.arguments.parser.ArgumentParser;
import sba.cl.bukkit.BukkitCommandContextKeys;
import sba.cl.bukkit.CloudBukkitCapabilities;
import sba.cl.bukkit.arguments.selector.MultipleEntitySelector;
import sba.cl.bukkit.parsers.selector.SelectorParseException;
import sba.cl.context.CommandContext;
import sba.cl.exceptions.parsing.NoInputProvidedException;

public final class MultipleEntitySelectorArgument<C>
extends CommandArgument<C, MultipleEntitySelector> {
    private MultipleEntitySelectorArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new MultipleEntitySelectorParser(), defaultValue, MultipleEntitySelector.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, MultipleEntitySelector> of(@NonNull String name) {
        return MultipleEntitySelectorArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, MultipleEntitySelector> optional(@NonNull String name) {
        return MultipleEntitySelectorArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, MultipleEntitySelector> optional(@NonNull String name, @NonNull String defaultEntitySelector) {
        return MultipleEntitySelectorArgument.newBuilder(name).asOptionalWithDefault(defaultEntitySelector).build();
    }

    public static final class MultipleEntitySelectorParser<C>
    implements ArgumentParser<C, MultipleEntitySelector> {
        @Override
        public @NonNull ArgumentParseResult<MultipleEntitySelector> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            List entities;
            if (!commandContext.get(BukkitCommandContextKeys.CLOUD_BUKKIT_CAPABILITIES).contains((Object)CloudBukkitCapabilities.BRIGADIER)) {
                return ArgumentParseResult.failure(new SelectorParseException("", commandContext, SelectorParseException.FailureReason.UNSUPPORTED_VERSION, MultipleEntitySelectorParser.class));
            }
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(MultipleEntitySelectorParser.class, commandContext));
            }
            try {
                entities = Bukkit.selectEntities((CommandSender)commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER), (String)input);
            }
            catch (IllegalArgumentException e) {
                return ArgumentParseResult.failure(new SelectorParseException(input, commandContext, SelectorParseException.FailureReason.MALFORMED_SELECTOR, MultipleEntitySelectorParser.class));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(new MultipleEntitySelector(input, entities));
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, MultipleEntitySelector> {
        private Builder(@NonNull String name) {
            super(MultipleEntitySelector.class, name);
        }

        public @NonNull MultipleEntitySelectorArgument<C> build() {
            return new MultipleEntitySelectorArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

