/*
 * Decompiled with CFR 0.152.
 */
package sba.si.builder;

import sba.si.inventory.LocalOptions;
import sba.sl.i.ItemStack;
import sba.sl.i.builder.ItemStackBuilder;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.spectator.Component;
import sba.sl.u.ReceiverConsumer;

public class LocalOptionsBuilder {
    private final LocalOptions localOptions;
    public static final int ROWS = 4;
    public static final int ITEMS_ON_ROW = 9;
    public static final int RENDER_ACTUAL_ROWS = 6;
    public static final int RENDER_OFFSET = 9;
    public static final int RENDER_HEADER_START = 0;
    public static final int RENDER_FOOTER_START = 45;

    public LocalOptionsBuilder backItem(ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(consumer);
        this.localOptions.setBackItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder pageBackItem(ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(consumer);
        this.localOptions.setPageBackItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder pageForwardItem(ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(consumer);
        this.localOptions.setPageForwardItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder cosmeticItem(ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(consumer);
        this.localOptions.setCosmeticItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder emptySlotItem(ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(consumer);
        this.localOptions.setEmptySlotItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder backItem(Object stack) {
        ItemStack item = ItemStackFactory.build(stack);
        this.localOptions.setBackItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder pageBackItem(Object stack) {
        ItemStack item = ItemStackFactory.build(stack);
        this.localOptions.setPageBackItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder pageForwardItem(Object stack) {
        ItemStack item = ItemStackFactory.build(stack);
        this.localOptions.setPageForwardItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder cosmeticItem(Object stack) {
        ItemStack item = ItemStackFactory.build(stack);
        this.localOptions.setCosmeticItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder emptySlotItem(Object stack) {
        ItemStack item = ItemStackFactory.build(stack);
        this.localOptions.setEmptySlotItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder backItem(Object stack, ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(stack, consumer);
        this.localOptions.setBackItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder pageBackItem(Object stack, ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(stack, consumer);
        this.localOptions.setPageBackItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder pageForwardItem(Object stack, ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(stack, consumer);
        this.localOptions.setPageForwardItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder cosmeticItem(Object stack, ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(stack, consumer);
        this.localOptions.setCosmeticItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder emptySlotItem(Object stack, ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(stack, consumer);
        this.localOptions.setEmptySlotItem(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public LocalOptionsBuilder rows(int rows) {
        this.localOptions.setRows(rows);
        return this;
    }

    public LocalOptionsBuilder itemsOnRow(int itemsOnRow) {
        this.localOptions.setItemsOnRow(itemsOnRow);
        return this;
    }

    public LocalOptionsBuilder renderActualRows(int renderActualItems) {
        this.localOptions.setRenderActualRows(renderActualItems);
        return this;
    }

    public LocalOptionsBuilder renderOffset(int renderOffset) {
        this.localOptions.setRenderOffset(renderOffset);
        return this;
    }

    public LocalOptionsBuilder renderHeaderStart(int renderHeaderStart) {
        this.localOptions.setRenderHeaderStart(renderHeaderStart);
        return this;
    }

    public LocalOptionsBuilder renderFooterStart(int renderFooterStart) {
        this.localOptions.setRenderFooterStart(renderFooterStart);
        return this;
    }

    public LocalOptionsBuilder inventoryType(String inventoryType) {
        this.localOptions.setInventoryType(inventoryType);
        return this;
    }

    public LocalOptionsBuilder showPageNumber(boolean showPageNumber) {
        this.localOptions.setShowPageNumber(showPageNumber);
        return this;
    }

    public LocalOptionsBuilder prefix(String prefix) {
        this.localOptions.setPrefix(Component.fromLegacy(prefix));
        return this;
    }

    public LocalOptionsBuilder prefix(Component prefix) {
        this.localOptions.setPrefix(prefix);
        return this;
    }

    private LocalOptionsBuilder(LocalOptions localOptions) {
        this.localOptions = localOptions;
    }

    public static LocalOptionsBuilder of(LocalOptions localOptions) {
        return new LocalOptionsBuilder(localOptions);
    }

    public LocalOptions getLocalOptions() {
        return this.localOptions;
    }
}

