/*
 * Decompiled with CFR 0.152.
 */
package sba.si.events;

import java.util.List;
import sba.si.inventory.InventorySet;
import sba.si.inventory.PlayerItemInfo;
import sba.si.inventory.Price;
import sba.si.inventory.Property;
import sba.sl.ev.CancellableEvent;
import sba.sl.i.ItemStack;
import sba.sl.pa.Player;
import sba.sl.u.ClickType;

public class OnTradeEvent
implements CancellableEvent {
    private final Player player;
    private final List<Price> prices;
    private final ItemStack stack;
    private final PlayerItemInfo item;
    private final ClickType clickType;
    private final boolean hasAnyExecutions;
    private boolean cancelled;
    private boolean runExecutions;

    public InventorySet getFormat() {
        return this.item.getFormat();
    }

    @Deprecated
    public int getPrice() {
        return this.prices.get(0).getAmount();
    }

    @Deprecated
    public String getType() {
        return this.prices.get(0).getCurrency();
    }

    public boolean hasPlayerInInventory() {
        return this.hasPlayerInInventory(this.stack);
    }

    public boolean hasPlayerInInventory(ItemStack item) {
        return this.player.getPlayerInventory().containsAtLeast(item, item.getAmount());
    }

    public List<ItemStack> sellStack() {
        return this.sellStack(this.stack);
    }

    public List<ItemStack> sellStack(ItemStack item) {
        return this.player.getPlayerInventory().removeItem(item);
    }

    public List<ItemStack> buyStack() {
        return this.buyStack(this.stack);
    }

    public List<ItemStack> buyStack(ItemStack item) {
        return this.player.getPlayerInventory().addItem(item);
    }

    public List<Property> getProperties() {
        return this.item.getProperties();
    }

    public boolean hasProperties() {
        return this.item.hasProperties();
    }

    @Override
    public boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public void cancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public Player getPlayer() {
        return this.player;
    }

    public List<Price> getPrices() {
        return this.prices;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public PlayerItemInfo getItem() {
        return this.item;
    }

    public ClickType getClickType() {
        return this.clickType;
    }

    public boolean isHasAnyExecutions() {
        return this.hasAnyExecutions;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isRunExecutions() {
        return this.runExecutions;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void setRunExecutions(boolean runExecutions) {
        this.runExecutions = runExecutions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OnTradeEvent)) {
            return false;
        }
        OnTradeEvent other = (OnTradeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasAnyExecutions() != other.isHasAnyExecutions()) {
            return false;
        }
        if (this.isCancelled() != other.isCancelled()) {
            return false;
        }
        if (this.isRunExecutions() != other.isRunExecutions()) {
            return false;
        }
        Player this$player = this.getPlayer();
        Player other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        List<Price> this$prices = this.getPrices();
        List<Price> other$prices = other.getPrices();
        if (this$prices == null ? other$prices != null : !((Object)this$prices).equals(other$prices)) {
            return false;
        }
        ItemStack this$stack = this.getStack();
        ItemStack other$stack = other.getStack();
        if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
            return false;
        }
        PlayerItemInfo this$item = this.getItem();
        PlayerItemInfo other$item = other.getItem();
        if (this$item == null ? other$item != null : !((Object)this$item).equals(other$item)) {
            return false;
        }
        ClickType this$clickType = this.getClickType();
        ClickType other$clickType = other.getClickType();
        return !(this$clickType == null ? other$clickType != null : !((Object)((Object)this$clickType)).equals((Object)other$clickType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OnTradeEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasAnyExecutions() ? 79 : 97);
        result = result * 59 + (this.isCancelled() ? 79 : 97);
        result = result * 59 + (this.isRunExecutions() ? 79 : 97);
        Player $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        List<Price> $prices = this.getPrices();
        result = result * 59 + ($prices == null ? 43 : ((Object)$prices).hashCode());
        ItemStack $stack = this.getStack();
        result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
        PlayerItemInfo $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        ClickType $clickType = this.getClickType();
        result = result * 59 + ($clickType == null ? 43 : ((Object)((Object)$clickType)).hashCode());
        return result;
    }

    public String toString() {
        return "OnTradeEvent(player=" + this.getPlayer() + ", prices=" + this.getPrices() + ", stack=" + this.getStack() + ", item=" + this.getItem() + ", clickType=" + this.getClickType() + ", hasAnyExecutions=" + this.isHasAnyExecutions() + ", cancelled=" + this.isCancelled() + ", runExecutions=" + this.isRunExecutions() + ")";
    }

    public OnTradeEvent(Player player, List<Price> prices, ItemStack stack, PlayerItemInfo item, ClickType clickType, boolean hasAnyExecutions) {
        this.player = player;
        this.prices = prices;
        this.stack = stack;
        this.item = item;
        this.clickType = clickType;
        this.hasAnyExecutions = hasAnyExecutions;
    }
}

