/*
 * Decompiled with CFR 0.152.
 */
package sba.si.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.si.inventory.Clone;
import sba.si.inventory.IdentifiableEntry;
import sba.si.inventory.InventoryLink;
import sba.si.inventory.InventorySet;
import sba.si.inventory.Position;
import sba.si.inventory.Price;
import sba.si.inventory.Property;
import sba.si.inventory.Queueable;
import sba.si.inventory.SubInventory;
import sba.si.inventory.Times;
import sba.sl.ev.EventManager;
import sba.sl.i.ItemStack;
import sba.sl.spectator.Book;

public class GenericItemInfo
implements Cloneable,
IdentifiableEntry {
    @NotNull
    private InventorySet format;
    private SubInventory parent;
    private int position;
    private ItemStack item;
    private final List<ItemStack> animation = new ArrayList<ItemStack>();
    private Supplier<Boolean> visible;
    private Supplier<Boolean> disabled;
    private String id;
    private final List<Property> properties = new ArrayList<Property>();
    @Deprecated
    private Book book;
    private Supplier<Boolean> written;
    private final EventManager eventManager;
    private SubInventory childInventory;
    private InventoryLink locate;
    private final List<String> executions = new ArrayList<String>();
    private final List<Price> prices = new ArrayList<Price>();
    private Position requestedPosition = new Position();
    @Nullable
    private Clone requestedClone;
    @Nullable
    private Times requestedTimes;
    @Nullable
    private String defaultCurrency;

    public GenericItemInfo(@NotNull InventorySet format) {
        this.format = format;
        this.eventManager = EventManager.createChildManager();
        this.eventManager.setCustomManager(format.getEventManager());
    }

    @Deprecated
    public void setFormat(@NotNull InventorySet format) {
        this.format = format;
        this.eventManager.setCustomManager(format.getEventManager());
        this.properties.forEach(property -> property.setInventorySet(format));
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    public boolean hasAnimation() {
        return !this.animation.isEmpty();
    }

    @Deprecated
    public boolean hasBook() {
        return this.book != null;
    }

    @Override
    public boolean hasChildInventory() {
        return this.childInventory != null;
    }

    public boolean isWritten() {
        return this.written != null ? this.written.get() : true;
    }

    public boolean isDisabled() {
        return this.disabled != null ? this.disabled.get() : false;
    }

    public boolean isVisible() {
        return this.visible != null ? this.visible.get() : true;
    }

    public Stream<Property> getPropertiesByName(@NotNull String name) {
        return this.properties.stream().filter(Objects::nonNull).filter(property -> name.equalsIgnoreCase(property.getPropertyName()));
    }

    public Optional<Property> getFirstPropertyByName(String name) {
        return this.getPropertiesByName(name).findFirst();
    }

    public void moveAbsolute(int position) {
        if (this.parent != null) {
            this.parent.dropContentsOn(position);
            this.position = position;
            this.parent.forceReload();
        }
    }

    public void moveRelative(int relative) {
        if (this.parent != null) {
            this.parent.dropContentsOn(this.position + relative);
            this.position += relative;
            this.parent.forceReload();
        }
    }

    public void repaint() {
        if (this.getParent() != null) {
            this.getParent().forceReload();
        }
    }

    public GenericItemInfo clone() {
        GenericItemInfo info = new GenericItemInfo(this.format);
        info.item = this.item != null ? this.item.clone() : null;
        this.animation.stream().map(ItemStack::clone).forEach(info.animation::add);
        info.visible = this.visible;
        info.disabled = this.disabled;
        info.written = this.written;
        info.id = this.id;
        this.properties.stream().map(Property::clone).forEach(info.properties::add);
        info.book = this.book != null ? Book.builder().title(this.book.title()).author(this.book.author()).pages(this.book.pages()).build() : null;
        info.eventManager.cloneEventManager(this.eventManager);
        info.executions.addAll(this.executions);
        this.prices.stream().map(Price::clone).forEach(info.prices::add);
        info.prices.addAll(this.prices);
        info.requestedPosition = this.requestedPosition != null ? this.requestedPosition.clone() : null;
        info.requestedClone = this.requestedClone != null ? this.requestedClone.clone() : null;
        info.requestedTimes = this.requestedTimes != null ? this.requestedTimes.clone() : null;
        info.defaultCurrency = this.defaultCurrency;
        info.locate = this.locate;
        if (this.hasChildInventory()) {
            info.childInventory = new SubInventory(false, info, this.format);
            this.childInventory.getContents().stream().map(GenericItemInfo::clone).forEach(info.childInventory.getWaitingQueue()::add);
            this.childInventory.getWaitingQueue().forEach(o -> {
                if (o instanceof GenericItemInfo) {
                    info.childInventory.getWaitingQueue().add(((GenericItemInfo)o).clone());
                } else {
                    info.childInventory.getWaitingQueue().add((Queueable)o);
                }
            });
        }
        return info;
    }

    @Override
    @NotNull
    public InventorySet getFormat() {
        return this.format;
    }

    @Override
    public SubInventory getParent() {
        return this.parent;
    }

    public int getPosition() {
        return this.position;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public List<ItemStack> getAnimation() {
        return this.animation;
    }

    public Supplier<Boolean> getVisible() {
        return this.visible;
    }

    public Supplier<Boolean> getDisabled() {
        return this.disabled;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Deprecated
    public Book getBook() {
        return this.book;
    }

    public Supplier<Boolean> getWritten() {
        return this.written;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public SubInventory getChildInventory() {
        return this.childInventory;
    }

    public InventoryLink getLocate() {
        return this.locate;
    }

    public List<String> getExecutions() {
        return this.executions;
    }

    public List<Price> getPrices() {
        return this.prices;
    }

    public Position getRequestedPosition() {
        return this.requestedPosition;
    }

    @Nullable
    public Clone getRequestedClone() {
        return this.requestedClone;
    }

    @Nullable
    public Times getRequestedTimes() {
        return this.requestedTimes;
    }

    @Nullable
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Override
    public void setParent(SubInventory parent) {
        this.parent = parent;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public void setVisible(Supplier<Boolean> visible) {
        this.visible = visible;
    }

    public void setDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Deprecated
    public void setBook(Book book) {
        this.book = book;
    }

    public void setWritten(Supplier<Boolean> written) {
        this.written = written;
    }

    @Override
    public void setChildInventory(SubInventory childInventory) {
        this.childInventory = childInventory;
    }

    public void setLocate(InventoryLink locate) {
        this.locate = locate;
    }

    public void setRequestedPosition(Position requestedPosition) {
        this.requestedPosition = requestedPosition;
    }

    public void setRequestedClone(@Nullable Clone requestedClone) {
        this.requestedClone = requestedClone;
    }

    public void setRequestedTimes(@Nullable Times requestedTimes) {
        this.requestedTimes = requestedTimes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericItemInfo)) {
            return false;
        }
        GenericItemInfo other = (GenericItemInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        InventorySet this$format = this.getFormat();
        InventorySet other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)this$format).equals(other$format)) {
            return false;
        }
        SubInventory this$parent = this.getParent();
        SubInventory other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        ItemStack this$item = this.getItem();
        ItemStack other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        List<ItemStack> this$animation = this.getAnimation();
        List<ItemStack> other$animation = other.getAnimation();
        if (this$animation == null ? other$animation != null : !((Object)this$animation).equals(other$animation)) {
            return false;
        }
        Supplier<Boolean> this$visible = this.getVisible();
        Supplier<Boolean> other$visible = other.getVisible();
        if (this$visible == null ? other$visible != null : !this$visible.equals(other$visible)) {
            return false;
        }
        Supplier<Boolean> this$disabled = this.getDisabled();
        Supplier<Boolean> other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !this$disabled.equals(other$disabled)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Property> this$properties = this.getProperties();
        List<Property> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Book this$book = this.getBook();
        Book other$book = other.getBook();
        if (this$book == null ? other$book != null : !this$book.equals(other$book)) {
            return false;
        }
        Supplier<Boolean> this$written = this.getWritten();
        Supplier<Boolean> other$written = other.getWritten();
        if (this$written == null ? other$written != null : !this$written.equals(other$written)) {
            return false;
        }
        EventManager this$eventManager = this.getEventManager();
        EventManager other$eventManager = other.getEventManager();
        if (this$eventManager == null ? other$eventManager != null : !this$eventManager.equals(other$eventManager)) {
            return false;
        }
        SubInventory this$childInventory = this.getChildInventory();
        SubInventory other$childInventory = other.getChildInventory();
        if (this$childInventory == null ? other$childInventory != null : !((Object)this$childInventory).equals(other$childInventory)) {
            return false;
        }
        InventoryLink this$locate = this.getLocate();
        InventoryLink other$locate = other.getLocate();
        if (this$locate == null ? other$locate != null : !((Object)this$locate).equals(other$locate)) {
            return false;
        }
        List<String> this$executions = this.getExecutions();
        List<String> other$executions = other.getExecutions();
        if (this$executions == null ? other$executions != null : !((Object)this$executions).equals(other$executions)) {
            return false;
        }
        List<Price> this$prices = this.getPrices();
        List<Price> other$prices = other.getPrices();
        if (this$prices == null ? other$prices != null : !((Object)this$prices).equals(other$prices)) {
            return false;
        }
        Position this$requestedPosition = this.getRequestedPosition();
        Position other$requestedPosition = other.getRequestedPosition();
        if (this$requestedPosition == null ? other$requestedPosition != null : !((Object)this$requestedPosition).equals(other$requestedPosition)) {
            return false;
        }
        Clone this$requestedClone = this.getRequestedClone();
        Clone other$requestedClone = other.getRequestedClone();
        if (this$requestedClone == null ? other$requestedClone != null : !((Object)this$requestedClone).equals(other$requestedClone)) {
            return false;
        }
        Times this$requestedTimes = this.getRequestedTimes();
        Times other$requestedTimes = other.getRequestedTimes();
        if (this$requestedTimes == null ? other$requestedTimes != null : !((Object)this$requestedTimes).equals(other$requestedTimes)) {
            return false;
        }
        String this$defaultCurrency = this.getDefaultCurrency();
        String other$defaultCurrency = other.getDefaultCurrency();
        return !(this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericItemInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPosition();
        InventorySet $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        SubInventory $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        ItemStack $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        List<ItemStack> $animation = this.getAnimation();
        result = result * 59 + ($animation == null ? 43 : ((Object)$animation).hashCode());
        Supplier<Boolean> $visible = this.getVisible();
        result = result * 59 + ($visible == null ? 43 : $visible.hashCode());
        Supplier<Boolean> $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : $disabled.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<Property> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Book $book = this.getBook();
        result = result * 59 + ($book == null ? 43 : $book.hashCode());
        Supplier<Boolean> $written = this.getWritten();
        result = result * 59 + ($written == null ? 43 : $written.hashCode());
        EventManager $eventManager = this.getEventManager();
        result = result * 59 + ($eventManager == null ? 43 : $eventManager.hashCode());
        SubInventory $childInventory = this.getChildInventory();
        result = result * 59 + ($childInventory == null ? 43 : ((Object)$childInventory).hashCode());
        InventoryLink $locate = this.getLocate();
        result = result * 59 + ($locate == null ? 43 : ((Object)$locate).hashCode());
        List<String> $executions = this.getExecutions();
        result = result * 59 + ($executions == null ? 43 : ((Object)$executions).hashCode());
        List<Price> $prices = this.getPrices();
        result = result * 59 + ($prices == null ? 43 : ((Object)$prices).hashCode());
        Position $requestedPosition = this.getRequestedPosition();
        result = result * 59 + ($requestedPosition == null ? 43 : ((Object)$requestedPosition).hashCode());
        Clone $requestedClone = this.getRequestedClone();
        result = result * 59 + ($requestedClone == null ? 43 : ((Object)$requestedClone).hashCode());
        Times $requestedTimes = this.getRequestedTimes();
        result = result * 59 + ($requestedTimes == null ? 43 : ((Object)$requestedTimes).hashCode());
        String $defaultCurrency = this.getDefaultCurrency();
        result = result * 59 + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
        return result;
    }

    public String toString() {
        return "GenericItemInfo(position=" + this.getPosition() + ", item=" + this.getItem() + ", animation=" + this.getAnimation() + ", visible=" + this.getVisible() + ", disabled=" + this.getDisabled() + ", id=" + this.getId() + ", properties=" + this.getProperties() + ", book=" + this.getBook() + ", written=" + this.getWritten() + ", eventManager=" + this.getEventManager() + ", childInventory=" + this.getChildInventory() + ", locate=" + this.getLocate() + ", executions=" + this.getExecutions() + ", prices=" + this.getPrices() + ", requestedPosition=" + this.getRequestedPosition() + ", requestedClone=" + this.getRequestedClone() + ", requestedTimes=" + this.getRequestedTimes() + ", defaultCurrency=" + this.getDefaultCurrency() + ")";
    }

    @Deprecated
    public void setDefaultCurrency(@Nullable String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }
}

