/*
 * Decompiled with CFR 0.152.
 */
package sba.si.inventory;

import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.sl.i.ItemStack;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.spectator.Component;

public class LocalOptions
implements Cloneable {
    public static final int ROWS = 4;
    public static final int ITEMS_ON_ROW = 9;
    public static final int RENDER_ACTUAL_ROWS = 6;
    public static final int RENDER_OFFSET = 9;
    public static final int RENDER_HEADER_START = 0;
    public static final int RENDER_FOOTER_START = 45;
    public static final boolean SHOW_PAGE_NUMBER = true;
    public static final String INVENTORY_TYPE = "CHEST";
    public static final Component PREFIX = Component.text("Inventory");
    public static final ItemStack BACK_ITEM;
    public static final ItemStack PAGE_BACK_ITEM;
    public static final ItemStack PAGE_FORWARD_ITEM;
    public static final ItemStack COSMETIC_ITEM;
    public static final ItemStack EMPTY_SLOT_ITEM;
    @Nullable
    private LocalOptions parent;
    @Nullable
    private ItemStack backItem;
    @Nullable
    private ItemStack pageBackItem;
    @Nullable
    private ItemStack pageForwardItem;
    @Nullable
    private ItemStack cosmeticItem;
    @Nullable
    private ItemStack emptySlotItem;
    @Nullable
    private Boolean showPageNumber;
    @Nullable
    private Component prefix;
    @Nullable
    private String inventoryType;
    @Nullable
    private Integer rows;
    @Nullable
    private Integer itemsOnRow;
    @Nullable
    private Integer renderActualRows;
    @Nullable
    private Integer renderOffset;
    @Nullable
    private Integer renderHeaderStart;
    @Nullable
    private Integer renderFooterStart;

    public ItemStack getBackItem() {
        return Optional.ofNullable(this.backItem).orElseGet(this.parent != null ? this.parent::getBackItem : BACK_ITEM::clone);
    }

    public ItemStack getPageBackItem() {
        return Optional.ofNullable(this.pageBackItem).orElseGet(this.parent != null ? this.parent::getPageBackItem : PAGE_BACK_ITEM::clone);
    }

    public ItemStack getPageForwardItem() {
        return Optional.ofNullable(this.pageForwardItem).orElseGet(this.parent != null ? this.parent::getPageForwardItem : PAGE_FORWARD_ITEM::clone);
    }

    public ItemStack getCosmeticItem() {
        return Optional.ofNullable(this.cosmeticItem).orElseGet(this.parent != null ? this.parent::getCosmeticItem : COSMETIC_ITEM::clone);
    }

    public ItemStack getEmptySlotItem() {
        return Optional.ofNullable(this.emptySlotItem).orElseGet(this.parent != null ? this.parent::getEmptySlotItem : EMPTY_SLOT_ITEM::clone);
    }

    public boolean isShowPageNumber() {
        return Optional.ofNullable(this.showPageNumber).orElseGet(this.parent != null ? this.parent::isShowPageNumber : () -> true);
    }

    public Component getPrefix() {
        return Optional.ofNullable(this.prefix).orElseGet(this.parent != null ? this.parent::getPrefix : () -> PREFIX);
    }

    public String getInventoryType() {
        return Optional.ofNullable(this.inventoryType).orElseGet(this.parent != null ? this.parent::getInventoryType : () -> INVENTORY_TYPE);
    }

    public int getRows() {
        return Optional.ofNullable(this.rows).orElseGet(this.parent != null ? this.parent::getRows : () -> 4);
    }

    public int getItemsOnRow() {
        return Optional.ofNullable(this.itemsOnRow).orElseGet(this.parent != null ? this.parent::getItemsOnRow : () -> 9);
    }

    public int getRenderActualRows() {
        return Optional.ofNullable(this.renderActualRows).orElseGet(this.parent != null ? this.parent::getRenderActualRows : () -> 6);
    }

    public int getRenderOffset() {
        return Optional.ofNullable(this.renderOffset).orElseGet(this.parent != null ? this.parent::getRenderOffset : () -> 9);
    }

    public int getRenderHeaderStart() {
        return Optional.ofNullable(this.renderHeaderStart).orElseGet(this.parent != null ? this.parent::getRenderHeaderStart : () -> 0);
    }

    public int getRenderFooterStart() {
        return Optional.ofNullable(this.renderFooterStart).orElseGet(this.parent != null ? this.parent::getRenderFooterStart : () -> 45);
    }

    public int getItemsOnPage() {
        return this.getItemsOnRow() * this.getRows();
    }

    public LocalOptions clone() {
        LocalOptions options = new LocalOptions();
        options.backItem = this.backItem != null ? this.backItem.clone() : null;
        options.pageBackItem = this.pageBackItem != null ? this.pageBackItem.clone() : null;
        options.pageForwardItem = this.pageForwardItem != null ? this.pageForwardItem.clone() : null;
        options.cosmeticItem = this.cosmeticItem != null ? this.cosmeticItem.clone() : null;
        options.showPageNumber = this.showPageNumber;
        options.prefix = this.prefix;
        options.inventoryType = this.inventoryType;
        options.rows = this.rows;
        options.itemsOnRow = this.itemsOnRow;
        options.renderActualRows = this.renderActualRows;
        options.renderOffset = this.renderOffset;
        options.renderHeaderStart = this.renderHeaderStart;
        options.renderFooterStart = this.renderFooterStart;
        return options;
    }

    public void fromNode(ConfigurationNode configurationNode) {
        ConfigurationNode showPageNumber;
        ConfigurationNode prefix;
        ConfigurationNode inventoryType;
        ConfigurationNode itemsOnRow;
        ConfigurationNode renderFooterStart;
        ConfigurationNode renderHeaderStart;
        ConfigurationNode renderOffset;
        ConfigurationNode renderActualRows;
        ConfigurationNode rows;
        ConfigurationNode cosmeticItem;
        ConfigurationNode pageForwardItem;
        ConfigurationNode pageBackItem;
        ConfigurationNode backItem = configurationNode.node("backItem");
        if (!backItem.empty()) {
            this.backItem = ItemStackFactory.build(backItem);
        }
        if (!(pageBackItem = configurationNode.node("pageBackItem")).empty()) {
            this.pageBackItem = ItemStackFactory.build(pageBackItem);
        }
        if (!(pageForwardItem = configurationNode.node("pageForwardItem")).empty()) {
            this.pageForwardItem = ItemStackFactory.build(pageForwardItem);
        }
        if (!(cosmeticItem = configurationNode.node("cosmeticItem")).empty()) {
            this.cosmeticItem = ItemStackFactory.build(cosmeticItem);
        }
        if (!(rows = configurationNode.node("rows")).empty()) {
            try {
                this.rows = rows.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(renderActualRows = configurationNode.node("render_actual_rows")).empty()) {
            try {
                this.renderActualRows = renderActualRows.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(renderOffset = configurationNode.node("render_offset")).empty()) {
            try {
                this.renderOffset = renderOffset.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(renderHeaderStart = configurationNode.node("render_header_start")).empty()) {
            try {
                this.renderHeaderStart = renderHeaderStart.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(renderFooterStart = configurationNode.node("render_footer_start")).empty()) {
            try {
                this.renderFooterStart = renderFooterStart.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(itemsOnRow = configurationNode.node("items_on_row")).empty()) {
            try {
                this.itemsOnRow = itemsOnRow.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(inventoryType = configurationNode.node("inventoryType")).empty()) {
            this.inventoryType = inventoryType.getString();
        }
        if (!(prefix = configurationNode.node("prefix")).empty()) {
            try {
                this.prefix = prefix.get(Component.class);
            }
            catch (SerializationException ignored) {
                try {
                    this.prefix = Component.fromLegacy(prefix.getString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!(showPageNumber = configurationNode.node("showPageNumber")).empty()) {
            this.showPageNumber = showPageNumber.getBoolean();
        }
    }

    @Nullable
    public Boolean getShowPageNumber() {
        return this.showPageNumber;
    }

    public void setBackItem(@Nullable ItemStack backItem) {
        this.backItem = backItem;
    }

    public void setPageBackItem(@Nullable ItemStack pageBackItem) {
        this.pageBackItem = pageBackItem;
    }

    public void setPageForwardItem(@Nullable ItemStack pageForwardItem) {
        this.pageForwardItem = pageForwardItem;
    }

    public void setCosmeticItem(@Nullable ItemStack cosmeticItem) {
        this.cosmeticItem = cosmeticItem;
    }

    public void setEmptySlotItem(@Nullable ItemStack emptySlotItem) {
        this.emptySlotItem = emptySlotItem;
    }

    public void setShowPageNumber(@Nullable Boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }

    public void setPrefix(@Nullable Component prefix) {
        this.prefix = prefix;
    }

    public void setInventoryType(@Nullable String inventoryType) {
        this.inventoryType = inventoryType;
    }

    public void setRows(@Nullable Integer rows) {
        this.rows = rows;
    }

    public void setItemsOnRow(@Nullable Integer itemsOnRow) {
        this.itemsOnRow = itemsOnRow;
    }

    public void setRenderActualRows(@Nullable Integer renderActualRows) {
        this.renderActualRows = renderActualRows;
    }

    public void setRenderOffset(@Nullable Integer renderOffset) {
        this.renderOffset = renderOffset;
    }

    public void setRenderHeaderStart(@Nullable Integer renderHeaderStart) {
        this.renderHeaderStart = renderHeaderStart;
    }

    public void setRenderFooterStart(@Nullable Integer renderFooterStart) {
        this.renderFooterStart = renderFooterStart;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalOptions)) {
            return false;
        }
        LocalOptions other = (LocalOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$showPageNumber = this.getShowPageNumber();
        Boolean other$showPageNumber = other.getShowPageNumber();
        if (this$showPageNumber == null ? other$showPageNumber != null : !((Object)this$showPageNumber).equals(other$showPageNumber)) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        if (this.getItemsOnRow() != other.getItemsOnRow()) {
            return false;
        }
        if (this.getRenderActualRows() != other.getRenderActualRows()) {
            return false;
        }
        if (this.getRenderOffset() != other.getRenderOffset()) {
            return false;
        }
        if (this.getRenderHeaderStart() != other.getRenderHeaderStart()) {
            return false;
        }
        if (this.getRenderFooterStart() != other.getRenderFooterStart()) {
            return false;
        }
        LocalOptions this$parent = this.getParent();
        LocalOptions other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        ItemStack this$backItem = this.getBackItem();
        ItemStack other$backItem = other.getBackItem();
        if (this$backItem == null ? other$backItem != null : !this$backItem.equals(other$backItem)) {
            return false;
        }
        ItemStack this$pageBackItem = this.getPageBackItem();
        ItemStack other$pageBackItem = other.getPageBackItem();
        if (this$pageBackItem == null ? other$pageBackItem != null : !this$pageBackItem.equals(other$pageBackItem)) {
            return false;
        }
        ItemStack this$pageForwardItem = this.getPageForwardItem();
        ItemStack other$pageForwardItem = other.getPageForwardItem();
        if (this$pageForwardItem == null ? other$pageForwardItem != null : !this$pageForwardItem.equals(other$pageForwardItem)) {
            return false;
        }
        ItemStack this$cosmeticItem = this.getCosmeticItem();
        ItemStack other$cosmeticItem = other.getCosmeticItem();
        if (this$cosmeticItem == null ? other$cosmeticItem != null : !this$cosmeticItem.equals(other$cosmeticItem)) {
            return false;
        }
        ItemStack this$emptySlotItem = this.getEmptySlotItem();
        ItemStack other$emptySlotItem = other.getEmptySlotItem();
        if (this$emptySlotItem == null ? other$emptySlotItem != null : !this$emptySlotItem.equals(other$emptySlotItem)) {
            return false;
        }
        Component this$prefix = this.getPrefix();
        Component other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$inventoryType = this.getInventoryType();
        String other$inventoryType = other.getInventoryType();
        return !(this$inventoryType == null ? other$inventoryType != null : !this$inventoryType.equals(other$inventoryType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $showPageNumber = this.getShowPageNumber();
        result = result * 59 + ($showPageNumber == null ? 43 : ((Object)$showPageNumber).hashCode());
        result = result * 59 + this.getRows();
        result = result * 59 + this.getItemsOnRow();
        result = result * 59 + this.getRenderActualRows();
        result = result * 59 + this.getRenderOffset();
        result = result * 59 + this.getRenderHeaderStart();
        result = result * 59 + this.getRenderFooterStart();
        LocalOptions $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        ItemStack $backItem = this.getBackItem();
        result = result * 59 + ($backItem == null ? 43 : $backItem.hashCode());
        ItemStack $pageBackItem = this.getPageBackItem();
        result = result * 59 + ($pageBackItem == null ? 43 : $pageBackItem.hashCode());
        ItemStack $pageForwardItem = this.getPageForwardItem();
        result = result * 59 + ($pageForwardItem == null ? 43 : $pageForwardItem.hashCode());
        ItemStack $cosmeticItem = this.getCosmeticItem();
        result = result * 59 + ($cosmeticItem == null ? 43 : $cosmeticItem.hashCode());
        ItemStack $emptySlotItem = this.getEmptySlotItem();
        result = result * 59 + ($emptySlotItem == null ? 43 : $emptySlotItem.hashCode());
        Component $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $inventoryType = this.getInventoryType();
        result = result * 59 + ($inventoryType == null ? 43 : $inventoryType.hashCode());
        return result;
    }

    public String toString() {
        return "LocalOptions(backItem=" + this.getBackItem() + ", pageBackItem=" + this.getPageBackItem() + ", pageForwardItem=" + this.getPageForwardItem() + ", cosmeticItem=" + this.getCosmeticItem() + ", emptySlotItem=" + this.getEmptySlotItem() + ", showPageNumber=" + this.getShowPageNumber() + ", prefix=" + this.getPrefix() + ", inventoryType=" + this.getInventoryType() + ", rows=" + this.getRows() + ", itemsOnRow=" + this.getItemsOnRow() + ", renderActualRows=" + this.getRenderActualRows() + ", renderOffset=" + this.getRenderOffset() + ", renderHeaderStart=" + this.getRenderHeaderStart() + ", renderFooterStart=" + this.getRenderFooterStart() + ")";
    }

    @Deprecated
    @Nullable
    public LocalOptions getParent() {
        return this.parent;
    }

    @Deprecated
    public void setParent(@Nullable LocalOptions parent) {
        this.parent = parent;
    }

    static {
        COSMETIC_ITEM = ItemStackFactory.getAir();
        EMPTY_SLOT_ITEM = ItemStackFactory.getAir();
        ItemStack backItem = ItemStackFactory.build("BARRIER");
        if (backItem == null) {
            backItem = ItemStackFactory.getAir();
        }
        BACK_ITEM = backItem;
        ItemStack arrowItem = ItemStackFactory.build("ARROW");
        if (arrowItem == null) {
            arrowItem = ItemStackFactory.getAir();
        }
        PAGE_BACK_ITEM = arrowItem;
        PAGE_FORWARD_ITEM = arrowItem;
    }
}

