/*
 * Decompiled with CFR 0.152.
 */
package sba.si.loaders;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Supplier;
import sba.c.ConfigurationNode;
import sba.c.loader.AbstractConfigurationLoader;
import sba.c.serialize.SerializationException;
import sba.si.builder.BuilderUtils;
import sba.si.builder.ItemInfoBuilder;
import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.Include;
import sba.si.inventory.Insert;
import sba.si.inventory.Property;
import sba.si.inventory.SubInventory;
import sba.si.loaders.Loader;
import sba.si.operations.OperationParser;
import sba.si.operations.conditions.Condition;
import sba.sl.i.ItemStack;
import sba.sl.i.builder.ItemStackFactory;

public class ConfigurateLoader
implements Loader {
    private final Supplier<AbstractConfigurationLoader.Builder<?, ?>> configurationLoaderBuilder;

    @Override
    public void loadPathInto(SubInventory subInventory, Path path, String configPath) throws Exception {
        Object loader = ((AbstractConfigurationLoader.Builder)this.configurationLoaderBuilder.get().path(path)).build();
        Object root = loader.load();
        String[] configKeys = configPath.split("\\.");
        ConfigurationNode node = root.node(configKeys);
        ConfigurateLoader.loadConfigurationNodeInto(subInventory, node);
    }

    public static void loadConfigurationNodeInto(SubInventory subInventory, ConfigurationNode configurationNode) {
        configurationNode.childrenList().forEach(itemNode -> {
            block46: {
                try {
                    if (itemNode.isMap()) {
                        if (itemNode.hasChild("define")) {
                            BuilderUtils.buildDefinition(subInventory.getInventorySet(), itemNode.node("define").getString());
                            break block46;
                        }
                        if (itemNode.hasChild("include")) {
                            subInventory.getWaitingQueue().add(Include.of(itemNode.node("include").getString()));
                            break block46;
                        }
                        if (itemNode.hasChild("insert")) {
                            ConfigurationNode insert = itemNode.node("insert");
                            ConfigurationNode items = itemNode.node("items");
                            ArrayList<String> inserts = new ArrayList<String>();
                            if (insert.isList()) {
                                inserts.addAll(insert.getList(String.class));
                            } else {
                                inserts.add(insert.getString());
                            }
                            SubInventory insertContainer = new SubInventory(false, null, subInventory.getInventorySet());
                            inserts.forEach(s -> subInventory.getWaitingQueue().add(new Insert((String)s, insertContainer)));
                            items.childrenList().forEach(child -> ConfigurateLoader.loadConfigurationNodeInto(subInventory, child));
                            break block46;
                        }
                        ConfigurationNode absolute = itemNode.node("absolute");
                        ConfigurationNode animation = itemNode.node("animation");
                        ConfigurationNode clone = itemNode.node("clone");
                        ConfigurationNode cloneMethod = itemNode.node("clone-method");
                        ConfigurationNode column = itemNode.node("column");
                        ConfigurationNode conditions = itemNode.node("conditions");
                        ConfigurationNode disabled = itemNode.node("disabled");
                        ConfigurationNode execute = itemNode.node("execute");
                        ConfigurationNode id = itemNode.node("id");
                        ConfigurationNode items = itemNode.node("items");
                        ConfigurationNode linebreak = itemNode.node("linebreak");
                        ConfigurationNode locate = itemNode.node("locate");
                        ConfigurationNode options = itemNode.node("options");
                        ConfigurationNode pagebreak = itemNode.node("pagebreak");
                        ConfigurationNode price = itemNode.node("price");
                        ConfigurationNode priceType = itemNode.node("price-type");
                        ConfigurationNode properties = itemNode.node("properties");
                        ConfigurationNode row = itemNode.node("row");
                        ConfigurationNode skip = itemNode.node("skip");
                        ConfigurationNode stack = itemNode.node("stack");
                        ConfigurationNode times = itemNode.node("times");
                        ConfigurationNode timesMethods = itemNode.node("times-methods");
                        ConfigurationNode visible = itemNode.node("visible");
                        ConfigurationNode write = itemNode.node("write");
                        GenericItemInfo item = new GenericItemInfo(subInventory.getInventorySet());
                        ItemStack builtItem = ItemStackFactory.build(stack);
                        item.setItem(builtItem != null ? builtItem : ItemStackFactory.getAir());
                        subInventory.getWaitingQueue().add(item);
                        ItemInfoBuilder builder = ItemInfoBuilder.of(item);
                        if (!absolute.empty()) {
                            builder.absolute(absolute.getInt());
                        }
                        if (!animation.empty() && animation.isList()) {
                            animation.childrenList().forEach(builder.getAnimation()::stack);
                        }
                        if (!clone.empty()) {
                            builder.clone(clone.getString());
                        }
                        if (!cloneMethod.empty()) {
                            builder.cloneMethod(cloneMethod.getString());
                        }
                        if (!column.empty()) {
                            try {
                                builder.column(column.get(Integer.class));
                            }
                            catch (NullPointerException | SerializationException ignored) {
                                builder.column(column.getString());
                            }
                        }
                        if (!conditions.empty()) {
                            conditions.childrenList().forEach(condition -> {
                                ConfigurationNode statement = condition.node("if");
                                ConfigurationNode thenBody = condition.node("then");
                                ConfigurationNode elseBody = condition.node("else");
                                if (!(statement.empty() || thenBody.empty() && elseBody.empty())) {
                                    Condition parsedCondition = OperationParser.getFinalCondition(item.getFormat(), statement.getString());
                                    builder.render(itemRenderEvent -> {
                                        if (parsedCondition.process(itemRenderEvent.getPlayer(), itemRenderEvent.getItem())) {
                                            if (!thenBody.empty()) {
                                                ConfigurationNode visibleRender = thenBody.node("visible");
                                                ConfigurationNode disabledRender = thenBody.node("disabled");
                                                ConfigurationNode stackRender = thenBody.node("stack");
                                                ConfigurationNode animationRender = thenBody.node("animation");
                                                if (!visibleRender.empty()) {
                                                    itemRenderEvent.setVisible(visibleRender.getBoolean());
                                                }
                                                if (!disabledRender.empty()) {
                                                    itemRenderEvent.setDisabled(disabledRender.getBoolean());
                                                }
                                                if (!stackRender.empty()) {
                                                    ItemStack anotherBuiltItem = ItemStackFactory.build(stackRender);
                                                    itemRenderEvent.setStack(anotherBuiltItem != null ? anotherBuiltItem : itemRenderEvent.getStack());
                                                }
                                                if (!animationRender.empty()) {
                                                    itemRenderEvent.getAnimation().clear();
                                                    animationRender.childrenList().forEach(itemRenderEvent.getAnimation()::stack);
                                                }
                                            }
                                        } else if (!elseBody.empty()) {
                                            ConfigurationNode visibleRender = elseBody.node("visible");
                                            ConfigurationNode disabledRender = elseBody.node("disabled");
                                            ConfigurationNode stackRender = elseBody.node("stack");
                                            ConfigurationNode animationRender = elseBody.node("animation");
                                            if (!visibleRender.empty()) {
                                                itemRenderEvent.setVisible(visibleRender.getBoolean());
                                            }
                                            if (!disabledRender.empty()) {
                                                itemRenderEvent.setDisabled(disabledRender.getBoolean());
                                            }
                                            if (!stackRender.empty()) {
                                                ItemStack anotherBuiltItem = ItemStackFactory.build(stackRender);
                                                itemRenderEvent.setStack(anotherBuiltItem != null ? anotherBuiltItem : itemRenderEvent.getStack());
                                            }
                                            if (!animationRender.empty()) {
                                                itemRenderEvent.getAnimation().clear();
                                                animationRender.childrenList().forEach(itemRenderEvent.getAnimation()::stack);
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        if (!disabled.empty()) {
                            builder.disabled(disabled.getString());
                        }
                        if (!execute.empty()) {
                            if (execute.isList()) {
                                builder.execute(execute.getList(String.class));
                            } else {
                                builder.execute(execute.getString());
                            }
                        }
                        if (!id.empty()) {
                            builder.id(id.getString());
                        }
                        if (!linebreak.empty()) {
                            builder.linebreak(linebreak.getString());
                        }
                        if (!locate.empty()) {
                            builder.locate(locate.getString());
                        }
                        if (!options.empty()) {
                            builder.getSubInventory().getLocalOptions().fromNode(options);
                        }
                        if (!pagebreak.empty()) {
                            builder.pagebreak(pagebreak.getString());
                        }
                        if (!price.empty()) {
                            builder.price(price.getString());
                        }
                        if (!priceType.empty()) {
                            builder.priceType(priceType.getString());
                        }
                        if (!properties.empty()) {
                            if (properties.isList()) {
                                properties.childrenList().forEach(builder::property);
                            } else if (properties.isMap()) {
                                builder.property(properties);
                            } else {
                                builder.property(properties.getString());
                            }
                        }
                        if (!row.empty()) {
                            builder.row(row.getInt());
                        }
                        if (!skip.empty()) {
                            builder.skip(skip.getInt(0));
                        }
                        if (!times.empty()) {
                            builder.times(times.getInt(1));
                        }
                        if (!timesMethods.empty()) {
                            if (timesMethods.isList()) {
                                builder.timesMethods(timesMethods.getList(Object.class));
                            } else {
                                builder.timesMethods(timesMethods.getString());
                            }
                        }
                        if (!visible.empty()) {
                            builder.visible(visible.getString());
                        }
                        if (!write.empty()) {
                            builder.write(write.getBoolean());
                        }
                        subInventory.getInventorySet().getVariableToPropertyMap().forEach((variable, property) -> {
                            ConfigurationNode node = itemNode.node(variable);
                            if (!node.empty()) {
                                item.getProperties().add(new Property(subInventory.getInventorySet(), (String)property, node));
                            }
                        });
                        if (!items.empty()) {
                            ConfigurateLoader.loadConfigurationNodeInto(builder.getSubInventory(), items);
                        }
                        break block46;
                    }
                    String string = itemNode.getString();
                    if (string != null) {
                        if ((string = string.trim()).startsWith("define ")) {
                            BuilderUtils.buildDefinition(subInventory.getInventorySet(), string.substring(7));
                        } else if (string.startsWith("@")) {
                            subInventory.getWaitingQueue().add(Include.of(string.substring(1)));
                        } else {
                            subInventory.getWaitingQueue().add(BuilderUtils.buildItem(subInventory.getInventorySet(), string));
                        }
                    }
                }
                catch (SerializationException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private ConfigurateLoader(Supplier<AbstractConfigurationLoader.Builder<?, ?>> configurationLoaderBuilder) {
        this.configurationLoaderBuilder = configurationLoaderBuilder;
    }

    public static ConfigurateLoader of(Supplier<AbstractConfigurationLoader.Builder<?, ?>> configurationLoaderBuilder) {
        return new ConfigurateLoader(configurationLoaderBuilder);
    }
}

