/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface OfflinePlayerHolder
extends Wrapper {
    @NotNull
    public static OfflinePlayerHolder of(@NotNull Object offlinePlayer) {
        OfflinePlayerHolder result = OfflinePlayerHolder.ofNullable(offlinePlayer);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap offline player: " + String.valueOf(offlinePlayer));
        }
        return result;
    }

    @Nullable
    public static OfflinePlayerHolder ofNullable(@Nullable Object offlinePlayer) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + OfflinePlayerHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (offlinePlayer == null) {
            return null;
        }
        return Provider.provider.apply(offlinePlayer);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable OfflinePlayerHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable OfflinePlayerHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + OfflinePlayerHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

