/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface BlockHolder
extends Wrapper {
    @NotNull
    public static BlockHolder of(@NotNull Object block) {
        BlockHolder result = BlockHolder.ofNullable(block);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap block: " + String.valueOf(block));
        }
        return result;
    }

    @Nullable
    public static BlockHolder ofNullable(@Nullable Object block) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + BlockHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (block == null) {
            return null;
        }
        return Provider.provider.apply(block);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable BlockHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable BlockHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + BlockHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

