/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.cn.type;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.cn.Container;
import sba.sl.cn.ContainerFactory;
import sba.sl.impl.container.type.InventoryTypeRegistry;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface InventoryType
extends RegistryItem,
RawValueHolder {
    @NotNull
    public String platformName();

    public int size();

    @Nullable
    default public <C extends Container> C createContainer(@Nullable ComponentLike name) {
        return this.createContainer(name != null ? name.asComponent() : null);
    }

    @Nullable
    default public <C extends Container> C createContainer(@Nullable Component name) {
        return ContainerFactory.createContainer(this, name);
    }

    @Nullable
    default public <C extends Container> C createContainer() {
        return ContainerFactory.createContainer(this);
    }

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.INVENTORY_TYPE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static InventoryType of(@MinecraftType(value=MinecraftType.Type.INVENTORY_TYPE) @NotNull Object inventoryType) {
        InventoryType result = InventoryType.ofNullable(inventoryType);
        Preconditions.checkNotNullIllegal(result, "Could not find inventory type: " + String.valueOf(inventoryType));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static InventoryType ofNullable(@MinecraftType(value=MinecraftType.Type.INVENTORY_TYPE) @Nullable Object inventoryType) {
        if (inventoryType instanceof InventoryType) {
            return (InventoryType)inventoryType;
        }
        return (InventoryType)InventoryTypeRegistry.getInstance().resolveMapping(inventoryType);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull InventoryType> all() {
        return InventoryTypeRegistry.getInstance().getRegistryItemStream();
    }
}

