/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.ev.player;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.ev.CancellableEvent;
import sba.sl.ev.Event;
import sba.sl.ev.PlatformEvent;
import sba.sl.ev.player.PlayerEvent;
import sba.sl.i.ItemStackView;
import sba.sl.i.ItemType;
import sba.sl.sl.EquipmentSlot;
import sba.sl.u.BlockFace;

public interface PlayerInteractEvent
extends CancellableEvent,
PlayerEvent,
PlatformEvent {
    @Nullable
    public ItemStackView item();

    @NotNull
    public Action action();

    @Nullable
    public BlockPlacement clickedBlock();

    @NotNull
    public BlockFace blockFace();

    @NotNull
    public Event.Result useClickedBlock();

    public void useClickedBlock(@NotNull Event.Result var1);

    @NotNull
    public Event.Result useItemInHand();

    public void useItemInHand(@NotNull Event.Result var1);

    @Nullable
    public EquipmentSlot hand();

    @Override
    default public void cancelled(boolean cancel) {
        this.useClickedBlock(cancel ? Event.Result.DENY : (this.useClickedBlock() == Event.Result.DENY ? Event.Result.DEFAULT : this.useClickedBlock()));
        this.useItemInHand(cancel ? Event.Result.DENY : (this.useItemInHand() == Event.Result.DENY ? Event.Result.DEFAULT : this.useItemInHand()));
    }

    default public boolean hasBlock() {
        return this.clickedBlock() != null;
    }

    default public boolean hasItem() {
        return this.item() != null;
    }

    @NotNull
    default public ItemType material() {
        ItemStackView item = this.item();
        if (item == null) {
            return ItemType.air();
        }
        return item.getType();
    }

    @Override
    @Deprecated
    default public boolean cancelled() {
        return this.useClickedBlock() == Event.Result.DENY;
    }

    public static enum Action {
        LEFT_CLICK_BLOCK,
        RIGHT_CLICK_BLOCK,
        LEFT_CLICK_AIR,
        RIGHT_CLICK_AIR,
        PHYSICAL;

        @NotNull
        public static final @NotNull List<@NotNull Action> VALUES;

        @NotNull
        public static Action convert(@NotNull String name) {
            return VALUES.stream().filter(next -> next.name().equalsIgnoreCase(name)).findFirst().orElse(LEFT_CLICK_AIR);
        }

        static {
            VALUES = List.of(Action.values());
        }
    }
}

