/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.gameevent;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.gameevent.GameEventRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.LimitedVersionSupport;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

@LimitedVersionSupport(value="Bukkit >= 1.17")
public interface GameEvent
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.GAME_EVENT) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static GameEvent of(@MinecraftType(value=MinecraftType.Type.GAME_EVENT) @NotNull Object gameEvent) {
        GameEvent result = GameEvent.ofNullable(gameEvent);
        Preconditions.checkNotNullIllegal(result, "Could not find game event: " + String.valueOf(gameEvent));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static GameEvent ofNullable(@MinecraftType(value=MinecraftType.Type.GAME_EVENT) @Nullable Object gameEvent) {
        if (gameEvent instanceof GameEvent) {
            return (GameEvent)gameEvent;
        }
        return (GameEvent)GameEventRegistry.getInstance().resolveMapping(gameEvent);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull GameEvent> all() {
        return GameEventRegistry.getInstance().getRegistryItemStream();
    }
}

