/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.h;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.h.HologramManager;
import sba.sl.i.ItemStack;
import sba.sl.t.TaskerTime;
import sba.sl.u.Pair;
import sba.sl.vi.DatableVisual;
import sba.sl.vi.LinedVisual;
import sba.sl.vi.TouchableVisual;
import sba.sl.w.Location;

public interface Hologram
extends LinedVisual<Hologram>,
DatableVisual<Hologram>,
TouchableVisual<Hologram> {
    public static final float DEFAULT_ROTATION_INCREMENT = 10.0f;

    @Contract(value="_ -> new")
    @NotNull
    public static Hologram of(@NotNull Location location) {
        return HologramManager.hologram(location);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Hologram touchableOf(@NotNull Location location) {
        return HologramManager.hologram(location, true);
    }

    @NotNull
    public @NotNull Pair<@NotNull Integer, @NotNull TaskerTime> rotationTime();

    @Contract(value="_ -> this")
    @NotNull
    public Hologram rotationTime(@NotNull @NotNull Pair<@NotNull Integer, @NotNull TaskerTime> var1);

    @NotNull
    public RotationMode rotationMode();

    @Contract(value="_ -> this")
    @NotNull
    public Hologram rotationMode(@NotNull RotationMode var1);

    @Contract(value="_ -> this")
    @NotNull
    public Hologram rotationIncrement(float var1);

    @Contract(value="_ -> this")
    @NotNull
    public Hologram item(@Nullable ItemStack var1);

    @Contract(value="_ -> this")
    @NotNull
    public Hologram itemPosition(@NotNull ItemPosition var1);

    @NotNull
    public ItemPosition itemPosition();

    public static enum ItemPosition {
        ABOVE,
        BELOW;

    }

    public static enum RotationMode {
        X,
        Y,
        Z,
        ALL,
        XY,
        NONE;

    }
}

