/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.i;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public enum HideFlags {
    ENCHANTMENTS("HIDE_ENCHANTS"),
    ATTRIBUTE_MODIFIERS("HIDE_ATTRIBUTES"),
    UNBREAKABLE("HIDE_UNBREAKABLE"),
    CAN_DESTROY("HIDE_DESTROYS"),
    CAN_PLACE_ON("HIDE_PLACED_ON"),
    MISC("HIDE_POTION_EFFECTS"),
    DYED("HIDE_DYE"),
    ARMOR_TRIM("HIDE_ARMOR_TRIM");

    @NotNull
    private final String bukkitName;
    @NotNull
    private static final @NotNull Map<@NotNull String, HideFlags> VALUES;

    @NotNull
    public static HideFlags convert(@NotNull String name) {
        return VALUES.getOrDefault(name.toUpperCase(Locale.ROOT), MISC);
    }

    @Generated
    private HideFlags(String bukkitName) {
        if (bukkitName == null) {
            throw new NullPointerException("bukkitName is marked non-null but is null");
        }
        this.bukkitName = bukkitName;
    }

    @NotNull
    @Generated
    public String getBukkitName() {
        return this.bukkitName;
    }

    static {
        VALUES = new HashMap<String, HideFlags>();
        for (HideFlags flag : HideFlags.values()) {
            VALUES.put(flag.name(), flag);
            VALUES.put(flag.bukkitName, flag);
        }
    }
}

