/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.i.builder;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.a.ItemAttribute;
import sba.sl.i.HideFlags;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemType;
import sba.sl.i.data.ItemData;
import sba.sl.i.meta.Enchantment;
import sba.sl.impl.attribute.Attributes;
import sba.sl.impl.item.builder.ShortStackDeserializer;
import sba.sl.nbt.CompoundTag;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.ide.MinecraftType;

public interface ItemStackBuilder {
    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder type(@NotNull ItemType var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder durability(int var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder amount(int var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder displayName(@Nullable Component var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder itemLore(@Nullable List<@NotNull Component> var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder attributeModifiers(@Nullable List<@NotNull ItemAttribute> var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder attributeModifier(@NotNull ItemAttribute var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder data(@NotNull ItemData var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder data(@NotNull @NotNull Consumer<@NotNull ItemData> var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder hideFlags(@Nullable List<@NotNull HideFlags> var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder hideFlag(@NotNull HideFlags var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder enchantments(@Nullable List<@NotNull Enchantment> var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder enchantment(@NotNull Enchantment var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder customModelData(@Nullable Integer var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder unbreakable(boolean var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder repairCost(int var1);

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder tag(@NotNull CompoundTag tag) {
        return this.tag(tag, 0);
    }

    @Contract(value="_,_ -> this")
    @NotNull
    public ItemStackBuilder tag(@NotNull CompoundTag var1, int var2);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder mergeTag(@NotNull CompoundTag var1);

    @Contract(pure=true)
    @Nullable
    public ItemStack build();

    @Deprecated
    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder platformMeta(Object var1);

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder type(@MinecraftType(value=MinecraftType.Type.ITEM_TYPE) @NotNull Object type) {
        if (type instanceof ItemType) {
            return this.type((ItemType)type);
        }
        ShortStackDeserializer.deserializeShortStack(this, type);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder name(@NotNull Component name) {
        return this.displayName(name);
    }

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder name(@NotNull ComponentLike name) {
        return this.displayName(name.asComponent());
    }

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder name(@Nullable String name) {
        return this.displayName(name == null ? null : Component.fromLegacy(name));
    }

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder localizedName(@Nullable String name) {
        return this.displayName(name == null ? null : (Component)Component.translatable().translate(name).build());
    }

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder repair(int repair) {
        return this.repairCost(repair);
    }

    @Contract(value="_ -> this")
    @NotNull
    default public <C> ItemStackBuilder flags(@Nullable List<@NotNull C> flags) {
        if (flags == null) {
            return this;
        }
        return this.hideFlags(flags.stream().map(o -> {
            if (o instanceof HideFlags) {
                return (HideFlags)((Object)((Object)o));
            }
            return HideFlags.convert(o.toString());
        }).collect(Collectors.toList()));
    }

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder lore(@NotNull Component var1);

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder lore(@NotNull ComponentLike component) {
        return this.lore(component.asComponent());
    }

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder lore(@Nullable String lore) {
        return this.lore(lore == null ? Component.empty() : Component.fromLegacy(lore));
    }

    @Contract(value="_ -> this")
    @NotNull
    default public <C> ItemStackBuilder lore(@NotNull List<@Nullable C> lore) {
        return this.itemLore(lore.stream().map(c -> {
            if (c instanceof ComponentLike) {
                return ((ComponentLike)c).asComponent();
            }
            return c == null ? Component.empty() : Component.fromLegacy(c.toString());
        }).collect(Collectors.toList()));
    }

    @Contract(value="_,_ -> this")
    @NotNull
    default public ItemStackBuilder enchant(@MinecraftType(value=MinecraftType.Type.ENCHANTMENT) @NotNull Object enchant, int level) {
        return this.enchant(String.valueOf(enchant) + " " + level);
    }

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder enchant(@NotNull @NotNull Map<@NotNull Object, Integer> enchants) {
        enchants.forEach(this::enchant);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder enchant(@NotNull @NotNull List<@NotNull Object> enchants) {
        enchants.forEach(this::enchant);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder enchant(@MinecraftType(value=MinecraftType.Type.ENCHANTMENT) @NotNull Object enchant) {
        Enchantment enchantment = Enchantment.ofNullable(enchant);
        if (enchantment != null) {
            this.enchantment(enchantment);
        }
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder potion(@MinecraftType(value=MinecraftType.Type.POTION) @NotNull Object var1);

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder attribute(@NotNull Object itemAttribute) {
        ItemAttribute attribute = Attributes.wrapItemAttribute(itemAttribute);
        if (attribute != null) {
            this.attributeModifier(attribute);
        }
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder effect(@MinecraftType(value=MinecraftType.Type.POTION_EFFECT) @NotNull Object var1);

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder recipe(@NotNull String key) {
        return this.recipe(ResourceLocation.of(key));
    }

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder recipe(@NotNull ResourceLocation var1);

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder color(@NotNull String color) {
        return this.color(Color.hexOrName(color));
    }

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder color(@NotNull Color var1);

    @Contract(value="_,_,_ -> this")
    @NotNull
    default public ItemStackBuilder color(int r, int g, int b) {
        return this.color(Color.rgb(r, g, b));
    }

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder skullOwner(@Nullable String var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder fireworkEffect(@NotNull Object var1);

    @Contract(value="_ -> this")
    @NotNull
    public ItemStackBuilder power(int var1);

    @Contract(value="_ -> this")
    @NotNull
    default public ItemStackBuilder damage(int damage) {
        return this.durability(damage);
    }
}

