/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator.bossbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import sba.k.a.bossbar.BossBar;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.adventure.spectator.bossbar.AdventureBossBarListener;
import sba.sl.impl.adventure.spectator.bossbar.BossBarUtils;
import sba.sl.spectator.Component;
import sba.sl.spectator.bossbar.BossBar;
import sba.sl.spectator.bossbar.BossBarColor;
import sba.sl.spectator.bossbar.BossBarDivision;
import sba.sl.spectator.bossbar.BossBarFlag;
import sba.sl.spectator.bossbar.BossBarListener;
import sba.sl.spectator.bossbar.RegisteredListener;
import sba.sl.u.BasicWrapper;
import sba.sl.u.Preconditions;

public class AdventureBossBar
extends BasicWrapper<BossBar>
implements sba.sl.spectator.bossbar.BossBar {
    public AdventureBossBar(@NotNull BossBar wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public Component title() {
        return AdventureBackend.wrapComponent(((BossBar)this.wrappedObject).name());
    }

    @Override
    @NotNull
    public sba.sl.spectator.bossbar.BossBar title(@NotNull Component title) {
        ((BossBar)this.wrappedObject).name(title.as(sba.k.a.t.Component.class));
        return this;
    }

    @Override
    public float progress() {
        return ((BossBar)this.wrappedObject).progress();
    }

    @Override
    @NotNull
    public sba.sl.spectator.bossbar.BossBar progress(float progress) {
        ((BossBar)this.wrappedObject).progress(progress);
        return this;
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull BossBarFlag> flags() {
        return BossBarUtils.convertFlags(((BossBar)this.wrappedObject).flags());
    }

    @Override
    @NotNull
    public sba.sl.spectator.bossbar.BossBar flags(@NotNull List<BossBarFlag> flags) {
        ((BossBar)this.wrappedObject).flags(BossBarUtils.convertFlags(flags));
        return this;
    }

    @Override
    @NotNull
    public BossBarColor color() {
        return BossBarUtils.convertColor(((BossBar)this.wrappedObject).color());
    }

    @Override
    @NotNull
    public sba.sl.spectator.bossbar.BossBar color(@NotNull BossBarColor color) {
        ((BossBar)this.wrappedObject).color(BossBarUtils.convertColor(color));
        return this;
    }

    @Override
    @NotNull
    public BossBarDivision division() {
        return BossBarUtils.convertDivision(((BossBar)this.wrappedObject).overlay());
    }

    @Override
    @NotNull
    public sba.sl.spectator.bossbar.BossBar division(@NotNull BossBarDivision division) {
        ((BossBar)this.wrappedObject).overlay(BossBarUtils.convertDivision(division));
        return this;
    }

    @Override
    @NotNull
    public RegisteredListener addListener(@NotNull BossBarListener listener) {
        AdventureBossBarListener adventureListener = new AdventureBossBarListener(listener);
        ((BossBar)this.wrappedObject).addListener(adventureListener);
        return adventureListener;
    }

    @Override
    public void removeListener(@NotNull RegisteredListener listener) {
        Preconditions.checkArgument(listener instanceof AdventureBossBarListener, "Unknown listener type");
        ((BossBar)this.wrappedObject).removeListener((AdventureBossBarListener)listener);
    }

    public static class AdventureBossBarBuilder
    implements BossBar.Builder {
        @NotNull
        private Component title = Component.empty();
        private float progress;
        @NotNull
        private BossBarColor color = BossBarColor.PINK;
        @NotNull
        private BossBarDivision division = BossBarDivision.NO_DIVISION;
        @NotNull
        private @NotNull Collection<@NotNull BossBarFlag> flags;
        @NotNull
        private final List<BossBarListener> listeners = new ArrayList<BossBarListener>();

        @Override
        @NotNull
        public BossBar.Builder flags(@NotNull @NotNull Collection<@NotNull BossBarFlag> flags) {
            this.flags = flags;
            return this;
        }

        @Override
        @NotNull
        public BossBar.Builder flags(BossBarFlag ... flags) {
            this.flags = Arrays.asList(flags);
            return this;
        }

        @Override
        @NotNull
        public BossBar.Builder listener(@NotNull BossBarListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
            return this;
        }

        @Override
        @NotNull
        public sba.sl.spectator.bossbar.BossBar build() {
            AdventureBossBar bossBar = new AdventureBossBar(BossBar.bossBar(this.title.as(sba.k.a.t.Component.class), this.progress, BossBarUtils.convertColor(this.color), BossBarUtils.convertDivision(this.division), BossBarUtils.convertFlags(this.flags)));
            this.listeners.forEach(bossBar::addListener);
            return bossBar;
        }

        @Override
        @Generated
        public AdventureBossBarBuilder title(@NotNull Component title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        @Override
        @Generated
        public AdventureBossBarBuilder progress(float progress) {
            this.progress = progress;
            return this;
        }

        @Override
        @Generated
        public AdventureBossBarBuilder color(@NotNull BossBarColor color) {
            if (color == null) {
                throw new NullPointerException("color is marked non-null but is null");
            }
            this.color = color;
            return this;
        }

        @Override
        @Generated
        public AdventureBossBarBuilder division(@NotNull BossBarDivision division) {
            if (division == null) {
                throw new NullPointerException("division is marked non-null but is null");
            }
            this.division = division;
            return this;
        }
    }
}

