/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator.event;

import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.k.a.t.event.HoverEvent;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.adventure.spectator.event.hover.AdventureEntityContent;
import sba.sl.impl.adventure.spectator.event.hover.AdventureItemContent;
import sba.sl.spectator.Component;
import sba.sl.spectator.event.HoverEvent;
import sba.sl.spectator.event.hover.Content;
import sba.sl.spectator.event.hover.EntityContent;
import sba.sl.spectator.event.hover.ItemContent;
import sba.sl.u.BasicWrapper;
import sba.sl.u.Preconditions;

public class AdventureHoverEvent
extends BasicWrapper<sba.k.a.t.event.HoverEvent<?>>
implements HoverEvent {
    public AdventureHoverEvent(@NotNull sba.k.a.t.event.HoverEvent<?> wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public HoverEvent.Action action() {
        try {
            return HoverEvent.Action.valueOf(Objects.requireNonNull(HoverEvent.Action.NAMES.key(((sba.k.a.t.event.HoverEvent)this.wrappedObject).action())).toUpperCase(Locale.ROOT));
        }
        catch (Throwable ignored) {
            return HoverEvent.Action.SHOW_TEXT;
        }
    }

    @Override
    @NotNull
    public Content content() {
        if (((sba.k.a.t.event.HoverEvent)this.wrappedObject).action().type() == sba.k.a.t.Component.class) {
            return AdventureBackend.wrapComponent((sba.k.a.t.Component)((sba.k.a.t.event.HoverEvent)this.wrappedObject).value());
        }
        if (((sba.k.a.t.event.HoverEvent)this.wrappedObject).action().type() == HoverEvent.ShowItem.class) {
            return new AdventureItemContent((HoverEvent.ShowItem)((sba.k.a.t.event.HoverEvent)this.wrappedObject).value());
        }
        if (((sba.k.a.t.event.HoverEvent)this.wrappedObject).action().type() == HoverEvent.ShowEntity.class) {
            return new AdventureEntityContent((HoverEvent.ShowEntity)((sba.k.a.t.event.HoverEvent)this.wrappedObject).value());
        }
        return Component.empty();
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        try {
            return super.as(type);
        }
        catch (Throwable ignored) {
            return AdventureBackend.getAdditionalHoverEventConverter().convert(this, type);
        }
    }

    public static class AdventureHoverEventBuilder
    implements HoverEvent.Builder {
        @NotNull
        private HoverEvent.Action action = HoverEvent.Action.SHOW_TEXT;
        @Nullable
        private Content content;

        @Override
        @NotNull
        public HoverEvent.Builder action(@NotNull HoverEvent.Action action) {
            this.action = action;
            return this;
        }

        @Override
        @NotNull
        public HoverEvent.Builder content(@NotNull Content content) {
            this.content = content;
            return this;
        }

        @Override
        @NotNull
        public HoverEvent build() {
            Preconditions.checkArgument(this.content != null, "Content is not specified!");
            switch (this.action) {
                case SHOW_TEXT: {
                    Preconditions.checkArgument(this.content instanceof Component, "Action type SHOW_TEXT requires a component to be present!");
                    return new AdventureHoverEvent(sba.k.a.t.event.HoverEvent.showText(this.content.as(sba.k.a.t.Component.class)));
                }
                case SHOW_ENTITY: {
                    Preconditions.checkArgument(this.content instanceof EntityContent, "Action type SHOW_ENTITY requires an EntityContent to be present!");
                    return new AdventureHoverEvent(sba.k.a.t.event.HoverEvent.showEntity(this.content.as(HoverEvent.ShowEntity.class)));
                }
                case SHOW_ITEM: {
                    Preconditions.checkArgument(this.content instanceof ItemContent, "Action type SHOW_ITEM requires an ItemContent to be present!");
                    return new AdventureHoverEvent(sba.k.a.t.event.HoverEvent.showItem(this.content.as(HoverEvent.ShowItem.class)));
                }
            }
            throw new IllegalArgumentException("Action type must be specified!");
        }
    }
}

