/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator.title;

import java.time.Duration;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.k.a.title.Title;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.adventure.spectator.AdventureFeature;
import sba.sl.spectator.Component;
import sba.sl.spectator.title.TimesProvider;
import sba.sl.spectator.title.Title;
import sba.sl.u.BasicWrapper;

public class AdventureTitle
extends BasicWrapper<Title>
implements sba.sl.spectator.title.Title {
    public AdventureTitle(@NotNull Title wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public Duration fadeIn() {
        Title.Times times = ((Title)this.wrappedObject).times();
        return times == null ? Title.DEFAULT_TIMES.fadeIn() : times.fadeIn();
    }

    @Override
    @NotNull
    public Duration stay() {
        Title.Times times = ((Title)this.wrappedObject).times();
        return times == null ? Title.DEFAULT_TIMES.stay() : times.stay();
    }

    @Override
    @NotNull
    public Duration fadeOut() {
        Title.Times times = ((Title)this.wrappedObject).times();
        return times == null ? Title.DEFAULT_TIMES.fadeOut() : times.fadeOut();
    }

    @Override
    @NotNull
    public Component title() {
        return AdventureBackend.wrapComponent(((Title)this.wrappedObject).title());
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withTitle(@NotNull Component title) {
        return new AdventureTitle(Title.title(title.as(sba.k.a.t.Component.class), ((Title)this.wrappedObject).subtitle(), ((Title)this.wrappedObject).times()));
    }

    @Override
    @NotNull
    public Component subtitle() {
        return AdventureBackend.wrapComponent(((Title)this.wrappedObject).subtitle());
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withSubtitle(@NotNull Component subtitle) {
        return new AdventureTitle(Title.title(((Title)this.wrappedObject).title(), subtitle.as(sba.k.a.t.Component.class), ((Title)this.wrappedObject).times()));
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withTimes(@NotNull TimesProvider times) {
        Title.Times advntrTimes = AdventureFeature.TIMES_NEW_FACTORY_METHOD.isSupported() ? Title.Times.times(times.fadeIn(), times.stay(), times.fadeOut()) : Title.Times.of(times.fadeIn(), times.stay(), times.fadeOut());
        return new AdventureTitle(Title.title(((Title)this.wrappedObject).title(), ((Title)this.wrappedObject).subtitle(), advntrTimes));
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withTimes(@Nullable Duration fadeIn, @Nullable Duration stay, @Nullable Duration fadeOut) {
        Title.Times advntrTimes = AdventureFeature.TIMES_NEW_FACTORY_METHOD.isSupported() ? Title.Times.times(fadeIn != null ? fadeIn : Title.DEFAULT_TIMES.fadeIn(), stay != null ? stay : Title.DEFAULT_TIMES.stay(), fadeOut != null ? fadeOut : Title.DEFAULT_TIMES.fadeOut()) : Title.Times.of(fadeIn != null ? fadeIn : Title.DEFAULT_TIMES.fadeIn(), stay != null ? stay : Title.DEFAULT_TIMES.stay(), fadeOut != null ? fadeOut : Title.DEFAULT_TIMES.fadeOut());
        return new AdventureTitle(Title.title(((Title)this.wrappedObject).title(), ((Title)this.wrappedObject).subtitle(), advntrTimes));
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withTimes(long fadeIn, long stay, long fadeOut) {
        Title.Times advntrTimes = AdventureFeature.TIMES_NEW_FACTORY_METHOD.isSupported() ? Title.Times.times(Duration.ofMillis(fadeIn * 50L), Duration.ofMillis(stay * 50L), Duration.ofMillis(fadeOut * 50L)) : Title.Times.of(Duration.ofMillis(fadeIn * 50L), Duration.ofMillis(stay * 50L), Duration.ofMillis(fadeOut * 50L));
        return new AdventureTitle(Title.title(((Title)this.wrappedObject).title(), ((Title)this.wrappedObject).subtitle(), advntrTimes));
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withFadeIn(@Nullable Duration fadeIn) {
        Title.Times advntrTimes = AdventureFeature.TIMES_NEW_FACTORY_METHOD.isSupported() ? Title.Times.times(fadeIn != null ? fadeIn : Title.DEFAULT_TIMES.fadeIn(), this.stay(), this.fadeOut()) : Title.Times.of(fadeIn != null ? fadeIn : Title.DEFAULT_TIMES.fadeIn(), this.stay(), this.fadeOut());
        return new AdventureTitle(Title.title(((Title)this.wrappedObject).title(), ((Title)this.wrappedObject).subtitle(), advntrTimes));
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withStay(@Nullable Duration stay) {
        Title.Times advntrTimes = AdventureFeature.TIMES_NEW_FACTORY_METHOD.isSupported() ? Title.Times.times(this.fadeIn(), stay != null ? stay : Title.DEFAULT_TIMES.stay(), this.fadeOut()) : Title.Times.of(this.fadeIn(), stay != null ? stay : Title.DEFAULT_TIMES.stay(), this.fadeOut());
        return new AdventureTitle(Title.title(((Title)this.wrappedObject).title(), ((Title)this.wrappedObject).subtitle(), advntrTimes));
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withFadeOut(@Nullable Duration fadeOut) {
        Title.Times advntrTimes = AdventureFeature.TIMES_NEW_FACTORY_METHOD.isSupported() ? Title.Times.times(this.fadeIn(), this.stay(), fadeOut != null ? fadeOut : Title.DEFAULT_TIMES.fadeOut()) : Title.Times.of(this.fadeIn(), this.stay(), fadeOut != null ? fadeOut : Title.DEFAULT_TIMES.fadeOut());
        return new AdventureTitle(Title.title(((Title)this.wrappedObject).title(), ((Title)this.wrappedObject).subtitle(), advntrTimes));
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withFadeIn(long ticks) {
        Title.Times advntrTimes = AdventureFeature.TIMES_NEW_FACTORY_METHOD.isSupported() ? Title.Times.times(Duration.ofMillis(ticks * 50L), this.stay(), this.fadeOut()) : Title.Times.of(Duration.ofMillis(ticks * 50L), this.stay(), this.fadeOut());
        return new AdventureTitle(Title.title(((Title)this.wrappedObject).title(), ((Title)this.wrappedObject).subtitle(), advntrTimes));
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withStay(long ticks) {
        Title.Times advntrTimes = AdventureFeature.TIMES_NEW_FACTORY_METHOD.isSupported() ? Title.Times.times(this.fadeIn(), Duration.ofMillis(ticks * 50L), this.fadeOut()) : Title.Times.of(this.fadeIn(), Duration.ofMillis(ticks * 50L), this.fadeOut());
        return new AdventureTitle(Title.title(((Title)this.wrappedObject).title(), ((Title)this.wrappedObject).subtitle(), advntrTimes));
    }

    @Override
    public @NotNull sba.sl.spectator.title.Title withFadeOut(long ticks) {
        Title.Times advntrTimes = AdventureFeature.TIMES_NEW_FACTORY_METHOD.isSupported() ? Title.Times.times(this.fadeIn(), this.stay(), Duration.ofMillis(ticks * 50L)) : Title.Times.of(this.fadeIn(), this.stay(), Duration.ofMillis(ticks * 50L));
        return new AdventureTitle(Title.title(((Title)this.wrappedObject).title(), ((Title)this.wrappedObject).subtitle(), advntrTimes));
    }

    @Override
    public  @NotNull Title.Builder toBuilder() {
        return new AdventureTitleBuilder(this.title(), this.subtitle(), this.fadeIn(), this.stay(), this.fadeOut());
    }

    public static class AdventureTitleBuilder
    implements Title.Builder {
        @NotNull
        private Component title = Component.empty();
        @NotNull
        private Component subtitle = Component.empty();
        @Nullable
        private Duration fadeIn;
        @Nullable
        private Duration stay;
        @Nullable
        private Duration fadeOut;

        @Override
        @NotNull
        public Title.Builder title(@NotNull Component title) {
            this.title = title;
            return this;
        }

        @Override
        @NotNull
        public Title.Builder subtitle(@NotNull Component subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @Override
        @NotNull
        public Title.Builder fadeIn(@Nullable Duration fadeIn) {
            this.fadeIn = fadeIn;
            return this;
        }

        @Override
        @NotNull
        public Title.Builder stay(@Nullable Duration stay) {
            this.stay = stay;
            return this;
        }

        @Override
        @NotNull
        public Title.Builder fadeOut(@Nullable Duration fadeOut) {
            this.fadeOut = fadeOut;
            return this;
        }

        @Override
        public @NotNull sba.sl.spectator.title.Title build() {
            if (this.fadeIn == null && this.fadeOut == null && this.stay == null) {
                return new AdventureTitle(Title.title(this.title.as(sba.k.a.t.Component.class), this.subtitle.as(sba.k.a.t.Component.class)));
            }
            Title.Times times = AdventureFeature.TIMES_NEW_FACTORY_METHOD.isSupported() ? Title.Times.times(this.fadeIn != null ? this.fadeIn : Title.DEFAULT_TIMES.fadeIn(), this.stay != null ? this.stay : Title.DEFAULT_TIMES.stay(), this.fadeOut != null ? this.fadeOut : Title.DEFAULT_TIMES.fadeOut()) : Title.Times.of(this.fadeIn != null ? this.fadeIn : Title.DEFAULT_TIMES.fadeIn(), this.stay != null ? this.stay : Title.DEFAULT_TIMES.stay(), this.fadeOut != null ? this.fadeOut : Title.DEFAULT_TIMES.fadeOut());
            return new AdventureTitle(Title.title(this.title.as(sba.k.a.t.Component.class), this.subtitle.as(sba.k.a.t.Component.class), times));
        }

        @Generated
        public AdventureTitleBuilder() {
        }

        @Generated
        public AdventureTitleBuilder(@NotNull Component title, @NotNull Component subtitle, @Nullable Duration fadeIn, @Nullable Duration stay, @Nullable Duration fadeOut) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (subtitle == null) {
                throw new NullPointerException("subtitle is marked non-null but is null");
            }
            this.title = title;
            this.subtitle = subtitle;
            this.fadeIn = fadeIn;
            this.stay = stay;
            this.fadeOut = fadeOut;
        }
    }
}

