/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.block;

import lombok.Generated;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.Bed;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import sba.sl.b.Block;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.block.BukkitBlock1_8;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.server.VVV.TileEntityFlowerPotAccessor;
import sba.sl.impl.nms.accessors.world.item.ItemAccessor;
import sba.sl.impl.nms.accessors.world.level.block.entity.BlockEntityAccessor;
import sba.sl.u.annotations.ide.LimitedVersionSupport;
import sba.sl.u.reflect.Reflect;

@LimitedVersionSupport(value="<= 1.12.2")
public final class BlockUtils1_8 {
    @NotNull
    public static Block getBlock(@NotNull BlockState state) {
        int tileEntityData = 0;
        if (BukkitFeature.COLORED_BEDS.isSupported() && state instanceof Bed) {
            tileEntityData = ((Bed)state).getColor().getWoolData();
        }
        if (state instanceof Skull) {
            tileEntityData = ((Skull)state).getSkullType().ordinal();
        }
        if (state.getType() == Material.FLOWER_POT) {
            if (BukkitFeature.FLOWER_POT_BLOCK_STATE.isSupported()) {
                MaterialData materialData = (MaterialData)Reflect.fastInvoke((Object)state, "getContents");
                if (materialData != null) {
                    tileEntityData = materialData.getItemType().getId() << 4 | materialData.getData();
                }
            } else {
                Integer id;
                Object tile = Reflect.getMethod((Object)state.getWorld(), "getTileEntityAt", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(state.getX(), state.getY(), state.getZ());
                if (tile != null && (id = (Integer)Reflect.fastInvoke(ItemAccessor.METHOD_GET_ID.get(), Reflect.fastInvoke(tile, TileEntityFlowerPotAccessor.METHOD_GET_ITEM.get()))) != null) {
                    Integer data = (Integer)Reflect.fastInvoke(tile, TileEntityFlowerPotAccessor.METHOD_GET_DATA.get());
                    tileEntityData = id << 4 | data;
                }
            }
        }
        return new BukkitBlock1_8(state.getData(), tileEntityData);
    }

    public static void finishSettingBlock(@NotNull BlockState state, @NotNull BukkitBlock1_8 type, boolean updateState) {
        int tileEntityVariant = type.tileEntityVariant();
        if (tileEntityVariant != 0) {
            if (BukkitFeature.COLORED_BEDS.isSupported() && state instanceof Bed) {
                ((Bed)state).setColor(DyeColor.getByWoolData((byte)((byte)tileEntityVariant)));
                if (updateState) {
                    state.update(true, false);
                }
            } else if (state instanceof Skull) {
                ((Skull)state).setSkullType(SkullType.values()[tileEntityVariant]);
                if (updateState) {
                    state.update(true, false);
                }
            } else if (state.getType() == Material.FLOWER_POT) {
                int id = tileEntityVariant >> 4;
                int data = tileEntityVariant & 0xF;
                Material flowerPotMaterial = (Material)Reflect.getMethod(Material.class, "getMaterial", Integer.TYPE).invokeStatic(id);
                if (flowerPotMaterial != null) {
                    if (BukkitFeature.FLOWER_POT_BLOCK_STATE.isSupported()) {
                        Reflect.getMethod((Object)state, "setContents", MaterialData.class).invoke(flowerPotMaterial.getNewData((byte)data));
                        if (updateState) {
                            state.update(true, false);
                        }
                    } else {
                        Object tile = Reflect.getMethod((Object)state.getWorld(), "getTileEntityAt", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(state.getX(), state.getY(), state.getZ());
                        if (tile != null) {
                            Reflect.fastInvoke(tile, TileEntityFlowerPotAccessor.METHOD_FUNC_145964_A.get(), Reflect.getMethod(ClassStorage.CB.CraftMagicNumbers, "getItem", Material.class).invokeStatic(flowerPotMaterial), data);
                            if (updateState) {
                                Reflect.fastInvoke(tile, BlockEntityAccessor.METHOD_SET_CHANGED.get());
                            }
                        }
                    }
                }
            }
        }
    }

    @Generated
    private BlockUtils1_8() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

