/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.block;

import java.util.concurrent.CompletableFuture;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.Block;
import sba.sl.b.BlockPlacement;
import sba.sl.b.snapshot.BlockSnapshot;
import sba.sl.impl.block.snapshot.BlockSnapshots;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.block.BlockUtils1_8;
import sba.sl.impl.bukkit.block.BukkitBlock1_8;
import sba.sl.impl.bukkit.compat.v1_12_2.AsyncChunk1_9;
import sba.sl.impl.world.Locations;
import sba.sl.u.BasicWrapper;
import sba.sl.u.reflect.Reflect;
import sba.sl.w.Location;

public final class BukkitBlockPlacement
extends BasicWrapper<org.bukkit.block.Block>
implements BlockPlacement {
    public BukkitBlockPlacement(@NotNull org.bukkit.block.Block wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public void block(@NotNull Block type) {
        this.setType(type, false);
    }

    @Override
    public void alterBlockWithoutPhysics(@NotNull Block type) {
        this.setType(type, true);
    }

    private void setType(@NotNull Block type, boolean ignorePhysics) {
        org.bukkit.Location bukkitLocation = ((org.bukkit.block.Block)this.wrappedObject).getLocation();
        CompletableFuture<Chunk> chunkFuture = BukkitFeature.CHUNK_ASYNC_1_13.isSupported() ? bukkitLocation.getWorld().getChunkAtAsync(bukkitLocation) : (BukkitFeature.CHUNK_ASYNC_1_9.isSupported() ? AsyncChunk1_9.getChunkAtAsync(bukkitLocation) : CompletableFuture.completedFuture(bukkitLocation.getChunk()));
        chunkFuture.thenAccept(result -> {
            if (!BukkitFeature.FLATTENING.isSupported()) {
                org.bukkit.block.Block bukkitBlock = bukkitLocation.getBlock();
                Material material = type.as(Material.class);
                bukkitBlock.setType(material, !ignorePhysics);
                if (type instanceof BukkitBlock1_8) {
                    Reflect.getMethod((Object)bukkitBlock, "setData", Byte.TYPE, Boolean.TYPE).invoke(((BukkitBlock1_8)type).legacyData(), !ignorePhysics);
                    BlockUtils1_8.finishSettingBlock(bukkitBlock.getState(), (BukkitBlock1_8)type, true);
                }
            } else {
                bukkitLocation.getBlock().setBlockData(type.as(BlockData.class), !ignorePhysics);
            }
        });
    }

    @Override
    @NotNull
    public Block block() {
        if (!BukkitFeature.FLATTENING.isSupported()) {
            return BlockUtils1_8.getBlock(((org.bukkit.block.Block)this.wrappedObject).getState());
        }
        return Block.of(((org.bukkit.block.Block)this.wrappedObject).getBlockData());
    }

    @Override
    @Nullable
    public BlockSnapshot blockSnapshot() {
        return BlockSnapshots.wrapBlockSnapshot(((org.bukkit.block.Block)this.wrappedObject).getState());
    }

    @Override
    public void breakNaturally() {
        ((org.bukkit.block.Block)this.wrappedObject).breakNaturally();
    }

    @Override
    @NotNull
    public Location location() {
        return Locations.wrapLocation(((org.bukkit.block.Block)this.wrappedObject).getLocation());
    }

    @Override
    public boolean isEmpty() {
        return ((org.bukkit.block.Block)this.wrappedObject).isEmpty();
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (BukkitFeature.FLATTENING.isSupported() && type == BlockData.class) {
            return (T)((org.bukkit.block.Block)this.wrappedObject).getBlockData();
        }
        if (type == org.bukkit.Location.class) {
            return (T)((org.bukkit.block.Block)this.wrappedObject).getLocation();
        }
        return super.as(type);
    }
}

