/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.block;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.Block;
import sba.sl.impl.block.BlockRegistry;
import sba.sl.impl.block.tags.ModernBlockTagBackPorts;
import sba.sl.impl.bukkit.block.BukkitBlock1_13;
import sba.sl.impl.bukkit.item.MaterialRegistry1_13_X;
import sba.sl.impl.bukkit.tags.KeyedUtils;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitBlockRegistry1_13
extends BlockRegistry {
    @NotNull
    private static final @NotNull Map<@NotNull Material, List<String>> tagBackPorts = new HashMap<Material, List<String>>();

    public BukkitBlockRegistry1_13() {
        this.specialType(Material.class, mat -> mat.isBlock() ? new BukkitBlock1_13((Material)mat) : null);
        this.specialType(BlockData.class, BukkitBlock1_13::new);
        Arrays.stream(Material.values()).filter(t -> !t.isLegacy() && t.isBlock()).forEach(material -> {
            List<String> backPorts;
            BukkitBlock1_13 holder = new BukkitBlock1_13((Material)material);
            NamespacedKey namespaced = material.getKey();
            if ("minecraft".equals(namespaced.getNamespace()) && (backPorts = ModernBlockTagBackPorts.getPortedTags(holder, s -> KeyedUtils.isTagged("blocks", new NamespacedKey("minecraft", s.toLowerCase(Locale.ROOT)), Material.class, material))) != null && !backPorts.isEmpty()) {
                tagBackPorts.put((Material)material, backPorts);
            }
        });
    }

    @Override
    @Nullable
    protected Block resolveMappingPlatform(@NotNull ResourceLocation location, @Nullable String blockState) {
        Material material = MaterialRegistry1_13_X.getInstance().get(new NamespacedKey(location.namespace(), location.path()));
        if (material != null && material.isBlock()) {
            if (blockState != null) {
                try {
                    return new BukkitBlock1_13(material.createBlockData(blockState));
                }
                catch (IllegalArgumentException ignored) {
                    return null;
                }
            }
            return new BukkitBlock1_13(material);
        }
        return null;
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull Block> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<Material, Block>(() -> Arrays.stream(Material.values()).filter(t -> !t.isLegacy() && t.isBlock()), BukkitBlock1_13::new, material -> ResourceLocation.of(material.getKey().getNamespace(), material.getKey().getKey()), (material, literal) -> material.getKey().getKey().contains((CharSequence)literal), (material, namespace) -> material.getKey().getNamespace().equals(namespace), List.of());
    }

    public static boolean hasTagInBackPorts(@NotNull Material material, @NotNull String tag) {
        return tagBackPorts.containsKey(material) && tagBackPorts.get(material).contains(tag);
    }
}

