/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.block.snapshot;

import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.Block;
import sba.sl.b.BlockPlacement;
import sba.sl.b.snapshot.BlockSnapshot;
import sba.sl.cn.Container;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.block.BlockUtils1_8;
import sba.sl.impl.bukkit.block.BukkitBlock1_8;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.container.BukkitContainer;
import sba.sl.impl.world.Locations;
import sba.sl.u.BasicWrapper;
import sba.sl.w.Location;

public class BukkitBlockSnapshot
extends BasicWrapper<BlockState>
implements BlockSnapshot {
    protected BukkitBlockSnapshot(@NotNull BlockState wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public Block block() {
        if (!BukkitFeature.FLATTENING.isSupported()) {
            return BlockUtils1_8.getBlock((BlockState)this.wrappedObject);
        }
        return Block.of(((BlockState)this.wrappedObject).getBlockData());
    }

    @Override
    public void block(@NotNull Block type) {
        if (!BukkitFeature.FLATTENING.isSupported()) {
            ((BlockState)this.wrappedObject).setType(type.as(Material.class));
            if (type instanceof BukkitBlock1_8) {
                ((BlockState)this.wrappedObject).setRawData(((BukkitBlock1_8)type).legacyData());
                BlockUtils1_8.finishSettingBlock((BlockState)this.wrappedObject, (BukkitBlock1_8)type, false);
            }
        } else {
            ((BlockState)this.wrappedObject).setBlockData(type.as(BlockData.class));
        }
    }

    @Override
    @Nullable
    public Location location() {
        if (((BlockState)this.wrappedObject).isPlaced()) {
            return Locations.wrapLocation(((BlockState)this.wrappedObject).getLocation());
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPlacement blockPlacement() {
        if (((BlockState)this.wrappedObject).isPlaced()) {
            return new BukkitBlockPlacement(((BlockState)this.wrappedObject).getBlock());
        }
        return null;
    }

    @Override
    public boolean updateBlock(boolean force, boolean applyPhysics) {
        return ((BlockState)this.wrappedObject).update(force, applyPhysics);
    }

    @Override
    public boolean holdsInventory() {
        return this.wrappedObject instanceof InventoryHolder;
    }

    @Override
    @Nullable
    public Container getInventory() {
        if (this.wrappedObject instanceof InventoryHolder) {
            return new BukkitContainer(((InventoryHolder)this.wrappedObject).getInventory());
        }
        return null;
    }
}

